package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.{JobRunId, JobName}
import scala.jdk.CollectionConverters.*
final case class StopJobRunRequest(name: JobName, runId: JobRunId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StopJobRunRequest = {
    import StopJobRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StopJobRunRequest
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .runId(JobRunId.unwrap(runId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StopJobRunRequest.ReadOnly =
    zio.aws.databrew.model.StopJobRunRequest.wrap(buildAwsValue())
}
object StopJobRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StopJobRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StopJobRunRequest =
      zio.aws.databrew.model.StopJobRunRequest(name, runId)
    def name: JobName
    def runId: JobRunId
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StopJobRunRequest
  ) extends zio.aws.databrew.model.StopJobRunRequest.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
    override val runId: JobRunId =
      zio.aws.databrew.model.primitives.JobRunId(impl.runId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StopJobRunRequest
  ): zio.aws.databrew.model.StopJobRunRequest.ReadOnly = new Wrapper(impl)
}
