package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobRunId
import scala.jdk.CollectionConverters.*
final case class StartJobRunResponse(runId: JobRunId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StartJobRunResponse = {
    import StartJobRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StartJobRunResponse
      .builder()
      .runId(JobRunId.unwrap(runId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StartJobRunResponse.ReadOnly =
    zio.aws.databrew.model.StartJobRunResponse.wrap(buildAwsValue())
}
object StartJobRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StartJobRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StartJobRunResponse =
      zio.aws.databrew.model.StartJobRunResponse(runId)
    def runId: JobRunId
    def getRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StartJobRunResponse
  ) extends zio.aws.databrew.model.StartJobRunResponse.ReadOnly {
    override val runId: JobRunId =
      zio.aws.databrew.model.primitives.JobRunId(impl.runId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StartJobRunResponse
  ): zio.aws.databrew.model.StartJobRunResponse.ReadOnly = new Wrapper(impl)
}
