package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.{RecipeVersion, RecipeName}
import scala.jdk.CollectionConverters.*
final case class BatchDeleteRecipeVersionRequest(
    name: RecipeName,
    recipeVersions: Iterable[RecipeVersion]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionRequest = {
    import BatchDeleteRecipeVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionRequest
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .recipeVersions(recipeVersions.map { item =>
        RecipeVersion.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.databrew.model.BatchDeleteRecipeVersionRequest.ReadOnly =
    zio.aws.databrew.model.BatchDeleteRecipeVersionRequest.wrap(buildAwsValue())
}
object BatchDeleteRecipeVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.BatchDeleteRecipeVersionRequest =
      zio.aws.databrew.model
        .BatchDeleteRecipeVersionRequest(name, recipeVersions)
    def name: RecipeName
    def recipeVersions: List[RecipeVersion]
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getRecipeVersions: ZIO[Any, Nothing, List[RecipeVersion]] =
      ZIO.succeed(recipeVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionRequest
  ) extends zio.aws.databrew.model.BatchDeleteRecipeVersionRequest.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val recipeVersions: List[RecipeVersion] = impl
      .recipeVersions()
      .asScala
      .map { item =>
        zio.aws.databrew.model.primitives.RecipeVersion(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.BatchDeleteRecipeVersionRequest
  ): zio.aws.databrew.model.BatchDeleteRecipeVersionRequest.ReadOnly =
    new Wrapper(impl)
}
