package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.DatasetName
import scala.jdk.CollectionConverters.*
final case class CreateDatasetResponse(name: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateDatasetResponse
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateDatasetResponse.ReadOnly =
    zio.aws.databrew.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateDatasetResponse =
      zio.aws.databrew.model.CreateDatasetResponse(name)
    def name: DatasetName
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateDatasetResponse
  ) extends zio.aws.databrew.model.CreateDatasetResponse.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateDatasetResponse
  ): zio.aws.databrew.model.CreateDatasetResponse.ReadOnly = new Wrapper(impl)
}
