package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Timeout,
  Arn,
  JobName,
  EncryptionKeyArn,
  MaxCapacity,
  MaxRetries
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateProfileJobRequest(
    configuration: Optional[zio.aws.databrew.model.ProfileConfiguration] =
      Optional.Absent,
    encryptionKeyArn: Optional[EncryptionKeyArn] = Optional.Absent,
    encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode] =
      Optional.Absent,
    name: JobName,
    logSubscription: Optional[zio.aws.databrew.model.LogSubscription] =
      Optional.Absent,
    maxCapacity: Optional[MaxCapacity] = Optional.Absent,
    maxRetries: Optional[MaxRetries] = Optional.Absent,
    outputLocation: zio.aws.databrew.model.S3Location,
    validationConfigurations: Optional[
      Iterable[zio.aws.databrew.model.ValidationConfiguration]
    ] = Optional.Absent,
    roleArn: Arn,
    timeout: Optional[Timeout] = Optional.Absent,
    jobSample: Optional[zio.aws.databrew.model.JobSample] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateProfileJobRequest = {
    import UpdateProfileJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateProfileJobRequest
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        encryptionKeyArn.map(value =>
          EncryptionKeyArn.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .name(JobName.unwrap(name): java.lang.String)
      .optionallyWith(logSubscription.map(value => value.unwrap))(
        _.logSubscription
      )
      .optionallyWith(
        maxCapacity.map(value => MaxCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .optionallyWith(
        maxRetries.map(value => MaxRetries.unwrap(value): Integer)
      )(_.maxRetries)
      .outputLocation(outputLocation.buildAwsValue())
      .optionallyWith(
        validationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationConfigurations)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .optionallyWith(jobSample.map(value => value.buildAwsValue()))(
        _.jobSample
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateProfileJobRequest.ReadOnly =
    zio.aws.databrew.model.UpdateProfileJobRequest.wrap(buildAwsValue())
}
object UpdateProfileJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateProfileJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateProfileJobRequest =
      zio.aws.databrew.model.UpdateProfileJobRequest(
        configuration.map(value => value.asEditable),
        encryptionKeyArn.map(value => value),
        encryptionMode.map(value => value),
        name,
        logSubscription.map(value => value),
        maxCapacity.map(value => value),
        maxRetries.map(value => value),
        outputLocation.asEditable,
        validationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn,
        timeout.map(value => value),
        jobSample.map(value => value.asEditable)
      )
    def configuration
        : Optional[zio.aws.databrew.model.ProfileConfiguration.ReadOnly]
    def encryptionKeyArn: Optional[EncryptionKeyArn]
    def encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode]
    def name: JobName
    def logSubscription: Optional[zio.aws.databrew.model.LogSubscription]
    def maxCapacity: Optional[MaxCapacity]
    def maxRetries: Optional[MaxRetries]
    def outputLocation: zio.aws.databrew.model.S3Location.ReadOnly
    def validationConfigurations: Optional[
      List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]
    ]
    def roleArn: Arn
    def timeout: Optional[Timeout]
    def jobSample: Optional[zio.aws.databrew.model.JobSample.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.ProfileConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getEncryptionKeyArn: ZIO[Any, AwsError, EncryptionKeyArn] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getEncryptionMode
        : ZIO[Any, AwsError, zio.aws.databrew.model.EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getLogSubscription
        : ZIO[Any, AwsError, zio.aws.databrew.model.LogSubscription] =
      AwsError.unwrapOptionField("logSubscription", logSubscription)
    def getMaxCapacity: ZIO[Any, AwsError, MaxCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getMaxRetries: ZIO[Any, AwsError, MaxRetries] =
      AwsError.unwrapOptionField("maxRetries", maxRetries)
    def getOutputLocation
        : ZIO[Any, Nothing, zio.aws.databrew.model.S3Location.ReadOnly] =
      ZIO.succeed(outputLocation)
    def getValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "validationConfigurations",
      validationConfigurations
    )
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getJobSample
        : ZIO[Any, AwsError, zio.aws.databrew.model.JobSample.ReadOnly] =
      AwsError.unwrapOptionField("jobSample", jobSample)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProfileJobRequest
  ) extends zio.aws.databrew.model.UpdateProfileJobRequest.ReadOnly {
    override val configuration
        : Optional[zio.aws.databrew.model.ProfileConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.databrew.model.ProfileConfiguration.wrap(value))
    override val encryptionKeyArn: Optional[EncryptionKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value => zio.aws.databrew.model.primitives.EncryptionKeyArn(value))
    override val encryptionMode
        : Optional[zio.aws.databrew.model.EncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value => zio.aws.databrew.model.EncryptionMode.wrap(value))
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
    override val logSubscription
        : Optional[zio.aws.databrew.model.LogSubscription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logSubscription())
        .map(value => zio.aws.databrew.model.LogSubscription.wrap(value))
    override val maxCapacity: Optional[MaxCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => zio.aws.databrew.model.primitives.MaxCapacity(value))
    override val maxRetries: Optional[MaxRetries] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRetries())
      .map(value => zio.aws.databrew.model.primitives.MaxRetries(value))
    override val outputLocation: zio.aws.databrew.model.S3Location.ReadOnly =
      zio.aws.databrew.model.S3Location.wrap(impl.outputLocation())
    override val validationConfigurations: Optional[
      List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ValidationConfiguration.wrap(item)
        }.toList
      )
    override val roleArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.roleArn())
    override val timeout: Optional[Timeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => zio.aws.databrew.model.primitives.Timeout(value))
    override val jobSample
        : Optional[zio.aws.databrew.model.JobSample.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobSample())
        .map(value => zio.aws.databrew.model.JobSample.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProfileJobRequest
  ): zio.aws.databrew.model.UpdateProfileJobRequest.ReadOnly = new Wrapper(impl)
}
