package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{ActionId, ProjectName, Result}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SendProjectSessionActionResponse(
    result: Optional[Result] = Optional.Absent,
    name: ProjectName,
    actionId: Optional[ActionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.SendProjectSessionActionResponse = {
    import SendProjectSessionActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.SendProjectSessionActionResponse
      .builder()
      .optionallyWith(
        result.map(value => Result.unwrap(value): java.lang.String)
      )(_.result)
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(actionId.map(value => ActionId.unwrap(value): Integer))(
        _.actionId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly =
    zio.aws.databrew.model.SendProjectSessionActionResponse
      .wrap(buildAwsValue())
}
object SendProjectSessionActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.SendProjectSessionActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.SendProjectSessionActionResponse =
      zio.aws.databrew.model.SendProjectSessionActionResponse(
        result.map(value => value),
        name,
        actionId.map(value => value)
      )
    def result: Optional[Result]
    def name: ProjectName
    def actionId: Optional[ActionId]
    def getResult: ZIO[Any, AwsError, Result] =
      AwsError.unwrapOptionField("result", result)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getActionId: ZIO[Any, AwsError, ActionId] =
      AwsError.unwrapOptionField("actionId", actionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.SendProjectSessionActionResponse
  ) extends zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly {
    override val result: Optional[Result] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => zio.aws.databrew.model.primitives.Result(value))
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
    override val actionId: Optional[ActionId] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => zio.aws.databrew.model.primitives.ActionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.SendProjectSessionActionResponse
  ): zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly =
    new Wrapper(impl)
}
