package zio.aws.databrew.model
import scala.jdk.CollectionConverters.*
sealed trait Source {
  def unwrap: software.amazon.awssdk.services.databrew.model.Source
}
object Source {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.Source
  ): zio.aws.databrew.model.Source = value match {
    case software.amazon.awssdk.services.databrew.model.Source.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.Source.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.databrew.model.Source.DATA_CATALOG =>
      val r = `DATA-CATALOG`
      r
    case software.amazon.awssdk.services.databrew.model.Source.DATABASE =>
      val r = DATABASE
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.Source {
    override def unwrap: software.amazon.awssdk.services.databrew.model.Source =
      software.amazon.awssdk.services.databrew.model.Source.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.databrew.model.Source {
    override def unwrap: software.amazon.awssdk.services.databrew.model.Source =
      software.amazon.awssdk.services.databrew.model.Source.S3
  }
  case object `DATA-CATALOG` extends zio.aws.databrew.model.Source {
    override def unwrap: software.amazon.awssdk.services.databrew.model.Source =
      software.amazon.awssdk.services.databrew.model.Source.DATA_CATALOG
  }
  case object DATABASE extends zio.aws.databrew.model.Source {
    override def unwrap: software.amazon.awssdk.services.databrew.model.Source =
      software.amazon.awssdk.services.databrew.model.Source.DATABASE
  }
}
