package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.DatasetName
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetRequest(
    name: DatasetName,
    format: Optional[zio.aws.databrew.model.InputFormat] = Optional.Absent,
    formatOptions: Optional[zio.aws.databrew.model.FormatOptions] =
      Optional.Absent,
    input: zio.aws.databrew.model.Input,
    pathOptions: Optional[zio.aws.databrew.model.PathOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest = {
    import UpdateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .input(input.buildAwsValue())
      .optionallyWith(pathOptions.map(value => value.buildAwsValue()))(
        _.pathOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateDatasetRequest.ReadOnly =
    zio.aws.databrew.model.UpdateDatasetRequest.wrap(buildAwsValue())
}
object UpdateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateDatasetRequest =
      zio.aws.databrew.model.UpdateDatasetRequest(
        name,
        format.map(value => value),
        formatOptions.map(value => value.asEditable),
        input.asEditable,
        pathOptions.map(value => value.asEditable)
      )
    def name: DatasetName
    def format: Optional[zio.aws.databrew.model.InputFormat]
    def formatOptions: Optional[zio.aws.databrew.model.FormatOptions.ReadOnly]
    def input: zio.aws.databrew.model.Input.ReadOnly
    def pathOptions: Optional[zio.aws.databrew.model.PathOptions.ReadOnly]
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
    def getFormat: ZIO[Any, AwsError, zio.aws.databrew.model.InputFormat] =
      AwsError.unwrapOptionField("format", format)
    def getFormatOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.FormatOptions.ReadOnly] =
      AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getInput: ZIO[Any, Nothing, zio.aws.databrew.model.Input.ReadOnly] =
      ZIO.succeed(input)
    def getPathOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.PathOptions.ReadOnly] =
      AwsError.unwrapOptionField("pathOptions", pathOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
  ) extends zio.aws.databrew.model.UpdateDatasetRequest.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
    override val format: Optional[zio.aws.databrew.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.databrew.model.InputFormat.wrap(value))
    override val formatOptions
        : Optional[zio.aws.databrew.model.FormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatOptions())
        .map(value => zio.aws.databrew.model.FormatOptions.wrap(value))
    override val input: zio.aws.databrew.model.Input.ReadOnly =
      zio.aws.databrew.model.Input.wrap(impl.input())
    override val pathOptions
        : Optional[zio.aws.databrew.model.PathOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathOptions())
        .map(value => zio.aws.databrew.model.PathOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
  ): zio.aws.databrew.model.UpdateDatasetRequest.ReadOnly = new Wrapper(impl)
}
