package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{CreateColumn, PathParameterName}
import scala.jdk.CollectionConverters.*
final case class DatasetParameter(
    name: PathParameterName,
    `type`: zio.aws.databrew.model.ParameterType,
    datetimeOptions: Optional[zio.aws.databrew.model.DatetimeOptions] =
      Optional.Absent,
    createColumn: Optional[CreateColumn] = Optional.Absent,
    filter: Optional[zio.aws.databrew.model.FilterExpression] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DatasetParameter = {
    import DatasetParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DatasetParameter
      .builder()
      .name(PathParameterName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(datetimeOptions.map(value => value.buildAwsValue()))(
        _.datetimeOptions
      )
      .optionallyWith(
        createColumn.map(value => CreateColumn.unwrap(value): java.lang.Boolean)
      )(_.createColumn)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DatasetParameter.ReadOnly =
    zio.aws.databrew.model.DatasetParameter.wrap(buildAwsValue())
}
object DatasetParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DatasetParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DatasetParameter =
      zio.aws.databrew.model.DatasetParameter(
        name,
        `type`,
        datetimeOptions.map(value => value.asEditable),
        createColumn.map(value => value),
        filter.map(value => value.asEditable)
      )
    def name: PathParameterName
    def `type`: zio.aws.databrew.model.ParameterType
    def datetimeOptions
        : Optional[zio.aws.databrew.model.DatetimeOptions.ReadOnly]
    def createColumn: Optional[CreateColumn]
    def filter: Optional[zio.aws.databrew.model.FilterExpression.ReadOnly]
    def getName: ZIO[Any, Nothing, PathParameterName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.databrew.model.ParameterType] =
      ZIO.succeed(`type`)
    def getDatetimeOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.DatetimeOptions.ReadOnly] =
      AwsError.unwrapOptionField("datetimeOptions", datetimeOptions)
    def getCreateColumn: ZIO[Any, AwsError, CreateColumn] =
      AwsError.unwrapOptionField("createColumn", createColumn)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.databrew.model.FilterExpression.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DatasetParameter
  ) extends zio.aws.databrew.model.DatasetParameter.ReadOnly {
    override val name: PathParameterName =
      zio.aws.databrew.model.primitives.PathParameterName(impl.name())
    override val `type`: zio.aws.databrew.model.ParameterType =
      zio.aws.databrew.model.ParameterType.wrap(impl.`type`())
    override val datetimeOptions
        : Optional[zio.aws.databrew.model.DatetimeOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datetimeOptions())
        .map(value => zio.aws.databrew.model.DatetimeOptions.wrap(value))
    override val createColumn: Optional[CreateColumn] = zio.aws.core.internal
      .optionalFromNullable(impl.createColumn())
      .map(value => zio.aws.databrew.model.primitives.CreateColumn(value))
    override val filter
        : Optional[zio.aws.databrew.model.FilterExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.databrew.model.FilterExpression.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DatasetParameter
  ): zio.aws.databrew.model.DatasetParameter.ReadOnly = new Wrapper(impl)
}
