package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ColumnStatisticsConfiguration(
    selectors: Optional[Iterable[zio.aws.databrew.model.ColumnSelector]] =
      Optional.Absent,
    statistics: zio.aws.databrew.model.StatisticsConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ColumnStatisticsConfiguration = {
    import ColumnStatisticsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ColumnStatisticsConfiguration
      .builder()
      .optionallyWith(
        selectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectors)
      .statistics(statistics.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly =
    zio.aws.databrew.model.ColumnStatisticsConfiguration.wrap(buildAwsValue())
}
object ColumnStatisticsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ColumnStatisticsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ColumnStatisticsConfiguration =
      zio.aws.databrew.model.ColumnStatisticsConfiguration(
        selectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statistics.asEditable
      )
    def selectors
        : Optional[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]]
    def statistics: zio.aws.databrew.model.StatisticsConfiguration.ReadOnly
    def getSelectors: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ColumnSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("selectors", selectors)
    def getStatistics: ZIO[
      Any,
      Nothing,
      zio.aws.databrew.model.StatisticsConfiguration.ReadOnly
    ] = ZIO.succeed(statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ColumnStatisticsConfiguration
  ) extends zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly {
    override val selectors
        : Optional[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.ColumnSelector.wrap(item)
          }.toList
        )
    override val statistics
        : zio.aws.databrew.model.StatisticsConfiguration.ReadOnly =
      zio.aws.databrew.model.StatisticsConfiguration.wrap(impl.statistics())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ColumnStatisticsConfiguration
  ): zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly =
    new Wrapper(impl)
}
