package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RulesetName
import scala.jdk.CollectionConverters.*
final case class DeleteRulesetResponse(name: RulesetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteRulesetResponse = {
    import DeleteRulesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteRulesetResponse
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly =
    zio.aws.databrew.model.DeleteRulesetResponse.wrap(buildAwsValue())
}
object DeleteRulesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteRulesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteRulesetResponse =
      zio.aws.databrew.model.DeleteRulesetResponse(name)
    def name: RulesetName
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRulesetResponse
  ) extends zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRulesetResponse
  ): zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly = new Wrapper(impl)
}
