package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Timeout,
  Arn,
  JobName,
  EncryptionKeyArn,
  MaxCapacity,
  MaxRetries
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateRecipeJobRequest(
    encryptionKeyArn: Optional[EncryptionKeyArn] = Optional.Absent,
    encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode] =
      Optional.Absent,
    name: JobName,
    logSubscription: Optional[zio.aws.databrew.model.LogSubscription] =
      Optional.Absent,
    maxCapacity: Optional[MaxCapacity] = Optional.Absent,
    maxRetries: Optional[MaxRetries] = Optional.Absent,
    outputs: Optional[Iterable[zio.aws.databrew.model.Output]] =
      Optional.Absent,
    dataCatalogOutputs: Optional[
      Iterable[zio.aws.databrew.model.DataCatalogOutput]
    ] = Optional.Absent,
    databaseOutputs: Optional[Iterable[zio.aws.databrew.model.DatabaseOutput]] =
      Optional.Absent,
    roleArn: Arn,
    timeout: Optional[Timeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateRecipeJobRequest = {
    import UpdateRecipeJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateRecipeJobRequest
      .builder()
      .optionallyWith(
        encryptionKeyArn.map(value =>
          EncryptionKeyArn.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .name(JobName.unwrap(name): java.lang.String)
      .optionallyWith(logSubscription.map(value => value.unwrap))(
        _.logSubscription
      )
      .optionallyWith(
        maxCapacity.map(value => MaxCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .optionallyWith(
        maxRetries.map(value => MaxRetries.unwrap(value): Integer)
      )(_.maxRetries)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCatalogOutputs)
      .optionallyWith(
        databaseOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databaseOutputs)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateRecipeJobRequest.ReadOnly =
    zio.aws.databrew.model.UpdateRecipeJobRequest.wrap(buildAwsValue())
}
object UpdateRecipeJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateRecipeJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateRecipeJobRequest =
      zio.aws.databrew.model.UpdateRecipeJobRequest(
        encryptionKeyArn.map(value => value),
        encryptionMode.map(value => value),
        name,
        logSubscription.map(value => value),
        maxCapacity.map(value => value),
        maxRetries.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        databaseOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn,
        timeout.map(value => value)
      )
    def encryptionKeyArn: Optional[EncryptionKeyArn]
    def encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode]
    def name: JobName
    def logSubscription: Optional[zio.aws.databrew.model.LogSubscription]
    def maxCapacity: Optional[MaxCapacity]
    def maxRetries: Optional[MaxRetries]
    def outputs: Optional[List[zio.aws.databrew.model.Output.ReadOnly]]
    def dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]]
    def databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]]
    def roleArn: Arn
    def timeout: Optional[Timeout]
    def getEncryptionKeyArn: ZIO[Any, AwsError, EncryptionKeyArn] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getEncryptionMode
        : ZIO[Any, AwsError, zio.aws.databrew.model.EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getLogSubscription
        : ZIO[Any, AwsError, zio.aws.databrew.model.LogSubscription] =
      AwsError.unwrapOptionField("logSubscription", logSubscription)
    def getMaxCapacity: ZIO[Any, AwsError, MaxCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getMaxRetries: ZIO[Any, AwsError, MaxRetries] =
      AwsError.unwrapOptionField("maxRetries", maxRetries)
    def getOutputs
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.Output.ReadOnly]] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getDataCatalogOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DataCatalogOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCatalogOutputs", dataCatalogOutputs)
    def getDatabaseOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DatabaseOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("databaseOutputs", databaseOutputs)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeJobRequest
  ) extends zio.aws.databrew.model.UpdateRecipeJobRequest.ReadOnly {
    override val encryptionKeyArn: Optional[EncryptionKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value => zio.aws.databrew.model.primitives.EncryptionKeyArn(value))
    override val encryptionMode
        : Optional[zio.aws.databrew.model.EncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value => zio.aws.databrew.model.EncryptionMode.wrap(value))
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
    override val logSubscription
        : Optional[zio.aws.databrew.model.LogSubscription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logSubscription())
        .map(value => zio.aws.databrew.model.LogSubscription.wrap(value))
    override val maxCapacity: Optional[MaxCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => zio.aws.databrew.model.primitives.MaxCapacity(value))
    override val maxRetries: Optional[MaxRetries] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRetries())
      .map(value => zio.aws.databrew.model.primitives.MaxRetries(value))
    override val outputs
        : Optional[List[zio.aws.databrew.model.Output.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.Output.wrap(item)
          }.toList
        )
    override val dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCatalogOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DataCatalogOutput.wrap(item)
          }.toList
        )
    override val databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DatabaseOutput.wrap(item)
          }.toList
        )
    override val roleArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.roleArn())
    override val timeout: Optional[Timeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => zio.aws.databrew.model.primitives.Timeout(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeJobRequest
  ): zio.aws.databrew.model.UpdateRecipeJobRequest.ReadOnly = new Wrapper(impl)
}
