package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters.*
final case class DeleteJobResponse(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteJobResponse = {
    import DeleteJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteJobResponse
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteJobResponse.ReadOnly =
    zio.aws.databrew.model.DeleteJobResponse.wrap(buildAwsValue())
}
object DeleteJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteJobResponse =
      zio.aws.databrew.model.DeleteJobResponse(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteJobResponse
  ) extends zio.aws.databrew.model.DeleteJobResponse.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteJobResponse
  ): zio.aws.databrew.model.DeleteJobResponse.ReadOnly = new Wrapper(impl)
}
