package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ScheduleName
import scala.jdk.CollectionConverters.*
final case class DescribeScheduleRequest(name: ScheduleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeScheduleRequest = {
    import DescribeScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeScheduleRequest
      .builder()
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeScheduleRequest.ReadOnly =
    zio.aws.databrew.model.DescribeScheduleRequest.wrap(buildAwsValue())
}
object DescribeScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeScheduleRequest =
      zio.aws.databrew.model.DescribeScheduleRequest(name)
    def name: ScheduleName
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeScheduleRequest
  ) extends zio.aws.databrew.model.DescribeScheduleRequest.ReadOnly {
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeScheduleRequest
  ): zio.aws.databrew.model.DescribeScheduleRequest.ReadOnly = new Wrapper(impl)
}
