package zio.aws.databrew.model
import scala.jdk.CollectionConverters.*
sealed trait DatabaseOutputMode {
  def unwrap: software.amazon.awssdk.services.databrew.model.DatabaseOutputMode
}
object DatabaseOutputMode {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.DatabaseOutputMode
  ): zio.aws.databrew.model.DatabaseOutputMode = value match {
    case software.amazon.awssdk.services.databrew.model.DatabaseOutputMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.DatabaseOutputMode.NEW_TABLE =>
      val r = NEW_TABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databrew.model.DatabaseOutputMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.DatabaseOutputMode =
      software.amazon.awssdk.services.databrew.model.DatabaseOutputMode.UNKNOWN_TO_SDK_VERSION
  }
  case object NEW_TABLE extends zio.aws.databrew.model.DatabaseOutputMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.DatabaseOutputMode =
      software.amazon.awssdk.services.databrew.model.DatabaseOutputMode.NEW_TABLE
  }
}
