package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Date,
  AccountId,
  LastModifiedBy,
  TagValue,
  ScheduleName,
  Arn,
  CronExpression,
  JobName,
  CreatedBy,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Schedule(
    accountId: Optional[AccountId] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    createDate: Optional[Date] = Optional.Absent,
    jobNames: Optional[Iterable[JobName]] = Optional.Absent,
    lastModifiedBy: Optional[LastModifiedBy] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    cronExpression: Optional[CronExpression] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    name: ScheduleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.Schedule = {
    import Schedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Schedule
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        jobNames.map(value =>
          value.map { item =>
            JobName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobNames)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        cronExpression.map(value =>
          CronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Schedule.ReadOnly =
    zio.aws.databrew.model.Schedule.wrap(buildAwsValue())
}
object Schedule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Schedule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Schedule =
      zio.aws.databrew.model.Schedule(
        accountId.map(value => value),
        createdBy.map(value => value),
        createDate.map(value => value),
        jobNames.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        resourceArn.map(value => value),
        cronExpression.map(value => value),
        tags.map(value => value),
        name
      )
    def accountId: Optional[AccountId]
    def createdBy: Optional[CreatedBy]
    def createDate: Optional[Date]
    def jobNames: Optional[List[JobName]]
    def lastModifiedBy: Optional[LastModifiedBy]
    def lastModifiedDate: Optional[Date]
    def resourceArn: Optional[Arn]
    def cronExpression: Optional[CronExpression]
    def tags: Optional[Map[TagKey, TagValue]]
    def name: ScheduleName
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getJobNames: ZIO[Any, AwsError, List[JobName]] =
      AwsError.unwrapOptionField("jobNames", jobNames)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getCronExpression: ZIO[Any, AwsError, CronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Schedule
  ) extends zio.aws.databrew.model.Schedule.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.databrew.model.primitives.AccountId(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val createDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val jobNames: Optional[List[JobName]] = zio.aws.core.internal
      .optionalFromNullable(impl.jobNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.JobName(item)
        }.toList
      )
    override val lastModifiedBy: Optional[LastModifiedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val cronExpression: Optional[CronExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cronExpression())
        .map(value => zio.aws.databrew.model.primitives.CronExpression(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Schedule
  ): zio.aws.databrew.model.Schedule.ReadOnly = new Wrapper(impl)
}
