package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ScheduleName
import scala.jdk.CollectionConverters.*
final case class DeleteScheduleRequest(name: ScheduleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteScheduleRequest = {
    import DeleteScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteScheduleRequest
      .builder()
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteScheduleRequest.ReadOnly =
    zio.aws.databrew.model.DeleteScheduleRequest.wrap(buildAwsValue())
}
object DeleteScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteScheduleRequest =
      zio.aws.databrew.model.DeleteScheduleRequest(name)
    def name: ScheduleName
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteScheduleRequest
  ) extends zio.aws.databrew.model.DeleteScheduleRequest.ReadOnly {
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteScheduleRequest
  ): zio.aws.databrew.model.DeleteScheduleRequest.ReadOnly = new Wrapper(impl)
}
