package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProfileConfiguration(
    datasetStatisticsConfiguration: Optional[
      zio.aws.databrew.model.StatisticsConfiguration
    ] = Optional.Absent,
    profileColumns: Optional[Iterable[zio.aws.databrew.model.ColumnSelector]] =
      Optional.Absent,
    columnStatisticsConfigurations: Optional[
      Iterable[zio.aws.databrew.model.ColumnStatisticsConfiguration]
    ] = Optional.Absent,
    entityDetectorConfiguration: Optional[
      zio.aws.databrew.model.EntityDetectorConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ProfileConfiguration = {
    import ProfileConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ProfileConfiguration
      .builder()
      .optionallyWith(
        datasetStatisticsConfiguration.map(value => value.buildAwsValue())
      )(_.datasetStatisticsConfiguration)
      .optionallyWith(
        profileColumns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profileColumns)
      .optionallyWith(
        columnStatisticsConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnStatisticsConfigurations)
      .optionallyWith(
        entityDetectorConfiguration.map(value => value.buildAwsValue())
      )(_.entityDetectorConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ProfileConfiguration.ReadOnly =
    zio.aws.databrew.model.ProfileConfiguration.wrap(buildAwsValue())
}
object ProfileConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ProfileConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ProfileConfiguration =
      zio.aws.databrew.model.ProfileConfiguration(
        datasetStatisticsConfiguration.map(value => value.asEditable),
        profileColumns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        columnStatisticsConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entityDetectorConfiguration.map(value => value.asEditable)
      )
    def datasetStatisticsConfiguration
        : Optional[zio.aws.databrew.model.StatisticsConfiguration.ReadOnly]
    def profileColumns
        : Optional[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]]
    def columnStatisticsConfigurations: Optional[
      List[zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly]
    ]
    def entityDetectorConfiguration
        : Optional[zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly]
    def getDatasetStatisticsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.StatisticsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "datasetStatisticsConfiguration",
      datasetStatisticsConfiguration
    )
    def getProfileColumns: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ColumnSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("profileColumns", profileColumns)
    def getColumnStatisticsConfigurations: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "columnStatisticsConfigurations",
      columnStatisticsConfigurations
    )
    def getEntityDetectorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "entityDetectorConfiguration",
      entityDetectorConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ProfileConfiguration
  ) extends zio.aws.databrew.model.ProfileConfiguration.ReadOnly {
    override val datasetStatisticsConfiguration
        : Optional[zio.aws.databrew.model.StatisticsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetStatisticsConfiguration())
        .map(value =>
          zio.aws.databrew.model.StatisticsConfiguration.wrap(value)
        )
    override val profileColumns
        : Optional[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.ColumnSelector.wrap(item)
          }.toList
        )
    override val columnStatisticsConfigurations: Optional[
      List[zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.columnStatisticsConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ColumnStatisticsConfiguration.wrap(item)
        }.toList
      )
    override val entityDetectorConfiguration: Optional[
      zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entityDetectorConfiguration())
      .map(value =>
        zio.aws.databrew.model.EntityDetectorConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ProfileConfiguration
  ): zio.aws.databrew.model.ProfileConfiguration.ReadOnly = new Wrapper(impl)
}
