package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RulesetName
import scala.jdk.CollectionConverters.*
final case class DescribeRulesetRequest(name: RulesetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeRulesetRequest = {
    import DescribeRulesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeRulesetRequest
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeRulesetRequest.ReadOnly =
    zio.aws.databrew.model.DescribeRulesetRequest.wrap(buildAwsValue())
}
object DescribeRulesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeRulesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeRulesetRequest =
      zio.aws.databrew.model.DescribeRulesetRequest(name)
    def name: RulesetName
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRulesetRequest
  ) extends zio.aws.databrew.model.DescribeRulesetRequest.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRulesetRequest
  ): zio.aws.databrew.model.DescribeRulesetRequest.ReadOnly = new Wrapper(impl)
}
