package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters.*
final case class CreateProfileJobResponse(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateProfileJobResponse = {
    import CreateProfileJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateProfileJobResponse
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly =
    zio.aws.databrew.model.CreateProfileJobResponse.wrap(buildAwsValue())
}
object CreateProfileJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateProfileJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateProfileJobResponse =
      zio.aws.databrew.model.CreateProfileJobResponse(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateProfileJobResponse
  ) extends zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateProfileJobResponse
  ): zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
