package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RecipeName
import scala.jdk.CollectionConverters.*
final case class PublishRecipeResponse(name: RecipeName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.PublishRecipeResponse = {
    import PublishRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.PublishRecipeResponse
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.PublishRecipeResponse.ReadOnly =
    zio.aws.databrew.model.PublishRecipeResponse.wrap(buildAwsValue())
}
object PublishRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.PublishRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.PublishRecipeResponse =
      zio.aws.databrew.model.PublishRecipeResponse(name)
    def name: RecipeName
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.PublishRecipeResponse
  ) extends zio.aws.databrew.model.PublishRecipeResponse.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.PublishRecipeResponse
  ): zio.aws.databrew.model.PublishRecipeResponse.ReadOnly = new Wrapper(impl)
}
