package zio.aws.databrew
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.databrew.model.primitives.{
  ParameterName,
  EntityType,
  RecipeVersion,
  ParameterValue,
  SheetName,
  TagValue,
  Statistic,
  SheetIndex,
  ValueReference,
  ColumnName,
  JobName,
  ConditionValue,
  PathParameterName,
  TagKey
}
import zio.aws.databrew.model.primitives.StartRowIndex.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.databrew.model.primitives.AccountId.Type
    object ActionId extends Subtype[Int]
    type ActionId = zio.aws.databrew.model.primitives.ActionId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.databrew.model.primitives.Arn.Type
    object AssumeControl extends Subtype[Boolean]
    type AssumeControl = zio.aws.databrew.model.primitives.AssumeControl.Type
    object Attempt extends Subtype[Int]
    type Attempt = zio.aws.databrew.model.primitives.Attempt.Type
    object Bucket extends Subtype[String]
    type Bucket = zio.aws.databrew.model.primitives.Bucket.Type
    object BucketOwner extends Subtype[String]
    type BucketOwner = zio.aws.databrew.model.primitives.BucketOwner.Type
    object CatalogId extends Subtype[String]
    type CatalogId = zio.aws.databrew.model.primitives.CatalogId.Type
    object ClientSessionId extends Subtype[String]
    type ClientSessionId =
      zio.aws.databrew.model.primitives.ClientSessionId.Type
    object ColumnName extends Subtype[String]
    type ColumnName = zio.aws.databrew.model.primitives.ColumnName.Type
    object ColumnRange extends Subtype[Int]
    type ColumnRange = zio.aws.databrew.model.primitives.ColumnRange.Type
    object Condition extends Subtype[String]
    type Condition = zio.aws.databrew.model.primitives.Condition.Type
    object ConditionValue extends Subtype[String]
    type ConditionValue = zio.aws.databrew.model.primitives.ConditionValue.Type
    object CreateColumn extends Subtype[Boolean]
    type CreateColumn = zio.aws.databrew.model.primitives.CreateColumn.Type
    object CreatedBy extends Subtype[String]
    type CreatedBy = zio.aws.databrew.model.primitives.CreatedBy.Type
    object CronExpression extends Subtype[String]
    type CronExpression = zio.aws.databrew.model.primitives.CronExpression.Type
    object DatabaseName extends Subtype[String]
    type DatabaseName = zio.aws.databrew.model.primitives.DatabaseName.Type
    object DatabaseTableName extends Subtype[String]
    type DatabaseTableName =
      zio.aws.databrew.model.primitives.DatabaseTableName.Type
    object DatasetName extends Subtype[String]
    type DatasetName = zio.aws.databrew.model.primitives.DatasetName.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.databrew.model.primitives.Date.Type
    object DatetimeFormat extends Subtype[String]
    type DatetimeFormat = zio.aws.databrew.model.primitives.DatetimeFormat.Type
    object Delimiter extends Subtype[String]
    type Delimiter = zio.aws.databrew.model.primitives.Delimiter.Type
    object Disabled extends Subtype[Boolean]
    type Disabled = zio.aws.databrew.model.primitives.Disabled.Type
    object EncryptionKeyArn extends Subtype[String]
    type EncryptionKeyArn =
      zio.aws.databrew.model.primitives.EncryptionKeyArn.Type
    object EntityType extends Subtype[String]
    type EntityType = zio.aws.databrew.model.primitives.EntityType.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.databrew.model.primitives.ErrorCode.Type
    object ExecutionTime extends Subtype[Int]
    type ExecutionTime = zio.aws.databrew.model.primitives.ExecutionTime.Type
    object Expression extends Subtype[String]
    type Expression = zio.aws.databrew.model.primitives.Expression.Type
    object GlueConnectionName extends Subtype[String]
    type GlueConnectionName =
      zio.aws.databrew.model.primitives.GlueConnectionName.Type
    object HeaderRow extends Subtype[Boolean]
    type HeaderRow = zio.aws.databrew.model.primitives.HeaderRow.Type
    object JobName extends Subtype[String]
    type JobName = zio.aws.databrew.model.primitives.JobName.Type
    object JobRunErrorMessage extends Subtype[String]
    type JobRunErrorMessage =
      zio.aws.databrew.model.primitives.JobRunErrorMessage.Type
    object JobRunId extends Subtype[String]
    type JobRunId = zio.aws.databrew.model.primitives.JobRunId.Type
    object JobSize extends Subtype[Long]
    type JobSize = zio.aws.databrew.model.primitives.JobSize.Type
    object Key extends Subtype[String]
    type Key = zio.aws.databrew.model.primitives.Key.Type
    object LastModifiedBy extends Subtype[String]
    type LastModifiedBy = zio.aws.databrew.model.primitives.LastModifiedBy.Type
    object LocaleCode extends Subtype[String]
    type LocaleCode = zio.aws.databrew.model.primitives.LocaleCode.Type
    object LogGroupName extends Subtype[String]
    type LogGroupName = zio.aws.databrew.model.primitives.LogGroupName.Type
    object MaxCapacity extends Subtype[Int]
    type MaxCapacity = zio.aws.databrew.model.primitives.MaxCapacity.Type
    object MaxFiles extends Subtype[Int]
    type MaxFiles = zio.aws.databrew.model.primitives.MaxFiles.Type
    object MaxOutputFiles extends Subtype[Int]
    type MaxOutputFiles = zio.aws.databrew.model.primitives.MaxOutputFiles.Type
    object MaxResults100 extends Subtype[Int]
    type MaxResults100 = zio.aws.databrew.model.primitives.MaxResults100.Type
    object MaxRetries extends Subtype[Int]
    type MaxRetries = zio.aws.databrew.model.primitives.MaxRetries.Type
    object MultiLine extends Subtype[Boolean]
    type MultiLine = zio.aws.databrew.model.primitives.MultiLine.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.databrew.model.primitives.NextToken.Type
    object OpenedBy extends Subtype[String]
    type OpenedBy = zio.aws.databrew.model.primitives.OpenedBy.Type
    object Operation extends Subtype[String]
    type Operation = zio.aws.databrew.model.primitives.Operation.Type
    object OverwriteOutput extends Subtype[Boolean]
    type OverwriteOutput =
      zio.aws.databrew.model.primitives.OverwriteOutput.Type
    object ParameterName extends Subtype[String]
    type ParameterName = zio.aws.databrew.model.primitives.ParameterName.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue = zio.aws.databrew.model.primitives.ParameterValue.Type
    object PathParameterName extends Subtype[String]
    type PathParameterName =
      zio.aws.databrew.model.primitives.PathParameterName.Type
    object Preview extends Subtype[Boolean]
    type Preview = zio.aws.databrew.model.primitives.Preview.Type
    object ProjectName extends Subtype[String]
    type ProjectName = zio.aws.databrew.model.primitives.ProjectName.Type
    object PublishedBy extends Subtype[String]
    type PublishedBy = zio.aws.databrew.model.primitives.PublishedBy.Type
    object QueryString extends Subtype[String]
    type QueryString = zio.aws.databrew.model.primitives.QueryString.Type
    object RecipeDescription extends Subtype[String]
    type RecipeDescription =
      zio.aws.databrew.model.primitives.RecipeDescription.Type
    object RecipeErrorMessage extends Subtype[String]
    type RecipeErrorMessage =
      zio.aws.databrew.model.primitives.RecipeErrorMessage.Type
    object RecipeName extends Subtype[String]
    type RecipeName = zio.aws.databrew.model.primitives.RecipeName.Type
    object RecipeVersion extends Subtype[String]
    type RecipeVersion = zio.aws.databrew.model.primitives.RecipeVersion.Type
    object Result extends Subtype[String]
    type Result = zio.aws.databrew.model.primitives.Result.Type
    object RowRange extends Subtype[Int]
    type RowRange = zio.aws.databrew.model.primitives.RowRange.Type
    object RuleCount extends Subtype[Int]
    type RuleCount = zio.aws.databrew.model.primitives.RuleCount.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.databrew.model.primitives.RuleName.Type
    object RulesetDescription extends Subtype[String]
    type RulesetDescription =
      zio.aws.databrew.model.primitives.RulesetDescription.Type
    object RulesetName extends Subtype[String]
    type RulesetName = zio.aws.databrew.model.primitives.RulesetName.Type
    object SampleSize extends Subtype[Int]
    type SampleSize = zio.aws.databrew.model.primitives.SampleSize.Type
    object ScheduleName extends Subtype[String]
    type ScheduleName = zio.aws.databrew.model.primitives.ScheduleName.Type
    object SheetIndex extends Subtype[Int]
    type SheetIndex = zio.aws.databrew.model.primitives.SheetIndex.Type
    object SheetName extends Subtype[String]
    type SheetName = zio.aws.databrew.model.primitives.SheetName.Type
    object StartColumnIndex extends Subtype[Int]
    type StartColumnIndex =
      zio.aws.databrew.model.primitives.StartColumnIndex.Type
    object StartRowIndex extends Subtype[Int]
    type StartRowIndex = zio.aws.databrew.model.primitives.StartRowIndex.Type
    object StartedBy extends Subtype[String]
    type StartedBy = zio.aws.databrew.model.primitives.StartedBy.Type
    object Statistic extends Subtype[String]
    type Statistic = zio.aws.databrew.model.primitives.Statistic.Type
    object StepIndex extends Subtype[Int]
    type StepIndex = zio.aws.databrew.model.primitives.StepIndex.Type
    object TableName extends Subtype[String]
    type TableName = zio.aws.databrew.model.primitives.TableName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.databrew.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.databrew.model.primitives.TagValue.Type
    object TargetColumn extends Subtype[String]
    type TargetColumn = zio.aws.databrew.model.primitives.TargetColumn.Type
    object ThresholdValue extends Subtype[Double]
    type ThresholdValue = zio.aws.databrew.model.primitives.ThresholdValue.Type
    object Timeout extends Subtype[Int]
    type Timeout = zio.aws.databrew.model.primitives.Timeout.Type
    object TimezoneOffset extends Subtype[String]
    type TimezoneOffset = zio.aws.databrew.model.primitives.TimezoneOffset.Type
    object ValueReference extends Subtype[String]
    type ValueReference = zio.aws.databrew.model.primitives.ValueReference.Type
  }
  type AllowedStatisticList = List[zio.aws.databrew.model.AllowedStatistics]
  type ColumnNameList = List[ColumnName]
  type ColumnSelectorList = List[zio.aws.databrew.model.ColumnSelector]
  type ColumnStatisticsConfigurationList =
    List[zio.aws.databrew.model.ColumnStatisticsConfiguration]
  type ConditionExpressionList =
    List[zio.aws.databrew.model.ConditionExpression]
  type DataCatalogOutputList = List[zio.aws.databrew.model.DataCatalogOutput]
  type DatabaseOutputList = List[zio.aws.databrew.model.DatabaseOutput]
  type DatasetList = List[zio.aws.databrew.model.Dataset]
  type EntityTypeList = List[EntityType]
  type HiddenColumnList = List[ColumnName]
  type JobList = List[zio.aws.databrew.model.Job]
  type JobNameList = List[JobName]
  type JobRunList = List[zio.aws.databrew.model.JobRun]
  type OutputList = List[zio.aws.databrew.model.Output]
  type ParameterMap = Map[ParameterName, ParameterValue]
  type PathParametersMap =
    Map[PathParameterName, zio.aws.databrew.model.DatasetParameter]
  type ProjectList = List[zio.aws.databrew.model.Project]
  type RecipeErrorList = List[zio.aws.databrew.model.RecipeVersionErrorDetail]
  type RecipeList = List[zio.aws.databrew.model.Recipe]
  type RecipeStepList = List[zio.aws.databrew.model.RecipeStep]
  type RecipeVersionList = List[RecipeVersion]
  type RuleList = List[zio.aws.databrew.model.Rule]
  type RulesetItemList = List[zio.aws.databrew.model.RulesetItem]
  type ScheduleList = List[zio.aws.databrew.model.Schedule]
  type SheetIndexList = List[SheetIndex]
  type SheetNameList = List[SheetName]
  type StatisticList = List[Statistic]
  type StatisticOverrideList = List[zio.aws.databrew.model.StatisticOverride]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type ValidationConfigurationList =
    List[zio.aws.databrew.model.ValidationConfiguration]
  type ValuesMap = Map[ValueReference, ConditionValue]
}
