package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FormatOptions(
    json: Optional[zio.aws.databrew.model.JsonOptions] = Optional.Absent,
    excel: Optional[zio.aws.databrew.model.ExcelOptions] = Optional.Absent,
    csv: Optional[zio.aws.databrew.model.CsvOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.FormatOptions = {
    import FormatOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.FormatOptions
      .builder()
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .optionallyWith(excel.map(value => value.buildAwsValue()))(_.excel)
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.FormatOptions.ReadOnly =
    zio.aws.databrew.model.FormatOptions.wrap(buildAwsValue())
}
object FormatOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.FormatOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.FormatOptions =
      zio.aws.databrew.model.FormatOptions(
        json.map(value => value.asEditable),
        excel.map(value => value.asEditable),
        csv.map(value => value.asEditable)
      )
    def json: Optional[zio.aws.databrew.model.JsonOptions.ReadOnly]
    def excel: Optional[zio.aws.databrew.model.ExcelOptions.ReadOnly]
    def csv: Optional[zio.aws.databrew.model.CsvOptions.ReadOnly]
    def getJson
        : ZIO[Any, AwsError, zio.aws.databrew.model.JsonOptions.ReadOnly] =
      AwsError.unwrapOptionField("json", json)
    def getExcel
        : ZIO[Any, AwsError, zio.aws.databrew.model.ExcelOptions.ReadOnly] =
      AwsError.unwrapOptionField("excel", excel)
    def getCsv: ZIO[Any, AwsError, zio.aws.databrew.model.CsvOptions.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.FormatOptions
  ) extends zio.aws.databrew.model.FormatOptions.ReadOnly {
    override val json: Optional[zio.aws.databrew.model.JsonOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.json())
        .map(value => zio.aws.databrew.model.JsonOptions.wrap(value))
    override val excel: Optional[zio.aws.databrew.model.ExcelOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excel())
        .map(value => zio.aws.databrew.model.ExcelOptions.wrap(value))
    override val csv: Optional[zio.aws.databrew.model.CsvOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.csv())
        .map(value => zio.aws.databrew.model.CsvOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.FormatOptions
  ): zio.aws.databrew.model.FormatOptions.ReadOnly = new Wrapper(impl)
}
