package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListJobRunsResponse(
    jobRuns: Iterable[zio.aws.databrew.model.JobRun],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListJobRunsResponse = {
    import ListJobRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListJobRunsResponse
      .builder()
      .jobRuns(jobRuns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListJobRunsResponse.ReadOnly =
    zio.aws.databrew.model.ListJobRunsResponse.wrap(buildAwsValue())
}
object ListJobRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListJobRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListJobRunsResponse =
      zio.aws.databrew.model.ListJobRunsResponse(
        jobRuns.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobRuns: List[zio.aws.databrew.model.JobRun.ReadOnly]
    def nextToken: Optional[NextToken]
    def getJobRuns
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.JobRun.ReadOnly]] =
      ZIO.succeed(jobRuns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListJobRunsResponse
  ) extends zio.aws.databrew.model.ListJobRunsResponse.ReadOnly {
    override val jobRuns: List[zio.aws.databrew.model.JobRun.ReadOnly] = impl
      .jobRuns()
      .asScala
      .map { item =>
        zio.aws.databrew.model.JobRun.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListJobRunsResponse
  ): zio.aws.databrew.model.ListJobRunsResponse.ReadOnly = new Wrapper(impl)
}
