package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  MaxOutputFiles,
  OverwriteOutput,
  ColumnName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Output(
    compressionFormat: Optional[zio.aws.databrew.model.CompressionFormat] =
      Optional.Absent,
    format: Optional[zio.aws.databrew.model.OutputFormat] = Optional.Absent,
    partitionColumns: Optional[Iterable[ColumnName]] = Optional.Absent,
    location: zio.aws.databrew.model.S3Location,
    overwrite: Optional[OverwriteOutput] = Optional.Absent,
    formatOptions: Optional[zio.aws.databrew.model.OutputFormatOptions] =
      Optional.Absent,
    maxOutputFiles: Optional[MaxOutputFiles] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Output
      .builder()
      .optionallyWith(compressionFormat.map(value => value.unwrap))(
        _.compressionFormat
      )
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        partitionColumns.map(value =>
          value.map { item =>
            ColumnName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionColumns)
      .location(location.buildAwsValue())
      .optionallyWith(
        overwrite.map(value => OverwriteOutput.unwrap(value): java.lang.Boolean)
      )(_.overwrite)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .optionallyWith(
        maxOutputFiles.map(value => MaxOutputFiles.unwrap(value): Integer)
      )(_.maxOutputFiles)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Output.ReadOnly =
    zio.aws.databrew.model.Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Output] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Output =
      zio.aws.databrew.model.Output(
        compressionFormat.map(value => value),
        format.map(value => value),
        partitionColumns.map(value => value),
        location.asEditable,
        overwrite.map(value => value),
        formatOptions.map(value => value.asEditable),
        maxOutputFiles.map(value => value)
      )
    def compressionFormat: Optional[zio.aws.databrew.model.CompressionFormat]
    def format: Optional[zio.aws.databrew.model.OutputFormat]
    def partitionColumns: Optional[List[ColumnName]]
    def location: zio.aws.databrew.model.S3Location.ReadOnly
    def overwrite: Optional[OverwriteOutput]
    def formatOptions
        : Optional[zio.aws.databrew.model.OutputFormatOptions.ReadOnly]
    def maxOutputFiles: Optional[MaxOutputFiles]
    def getCompressionFormat
        : ZIO[Any, AwsError, zio.aws.databrew.model.CompressionFormat] =
      AwsError.unwrapOptionField("compressionFormat", compressionFormat)
    def getFormat: ZIO[Any, AwsError, zio.aws.databrew.model.OutputFormat] =
      AwsError.unwrapOptionField("format", format)
    def getPartitionColumns: ZIO[Any, AwsError, List[ColumnName]] =
      AwsError.unwrapOptionField("partitionColumns", partitionColumns)
    def getLocation
        : ZIO[Any, Nothing, zio.aws.databrew.model.S3Location.ReadOnly] =
      ZIO.succeed(location)
    def getOverwrite: ZIO[Any, AwsError, OverwriteOutput] =
      AwsError.unwrapOptionField("overwrite", overwrite)
    def getFormatOptions: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.OutputFormatOptions.ReadOnly
    ] = AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getMaxOutputFiles: ZIO[Any, AwsError, MaxOutputFiles] =
      AwsError.unwrapOptionField("maxOutputFiles", maxOutputFiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Output
  ) extends zio.aws.databrew.model.Output.ReadOnly {
    override val compressionFormat
        : Optional[zio.aws.databrew.model.CompressionFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionFormat())
        .map(value => zio.aws.databrew.model.CompressionFormat.wrap(value))
    override val format: Optional[zio.aws.databrew.model.OutputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.databrew.model.OutputFormat.wrap(value))
    override val partitionColumns: Optional[List[ColumnName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.primitives.ColumnName(item)
          }.toList
        )
    override val location: zio.aws.databrew.model.S3Location.ReadOnly =
      zio.aws.databrew.model.S3Location.wrap(impl.location())
    override val overwrite: Optional[OverwriteOutput] = zio.aws.core.internal
      .optionalFromNullable(impl.overwrite())
      .map(value => zio.aws.databrew.model.primitives.OverwriteOutput(value))
    override val formatOptions
        : Optional[zio.aws.databrew.model.OutputFormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatOptions())
        .map(value => zio.aws.databrew.model.OutputFormatOptions.wrap(value))
    override val maxOutputFiles: Optional[MaxOutputFiles] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxOutputFiles())
        .map(value => zio.aws.databrew.model.primitives.MaxOutputFiles(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Output
  ): zio.aws.databrew.model.Output.ReadOnly = new Wrapper(impl)
}
