package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  RecipeVersion,
  NextToken,
  MaxResults100
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRecipesRequest(
    maxResults: Optional[MaxResults100] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    recipeVersion: Optional[RecipeVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRecipesRequest = {
    import ListRecipesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRecipesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        recipeVersion.map(value =>
          RecipeVersion.unwrap(value): java.lang.String
        )
      )(_.recipeVersion)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRecipesRequest.ReadOnly =
    zio.aws.databrew.model.ListRecipesRequest.wrap(buildAwsValue())
}
object ListRecipesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRecipesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRecipesRequest =
      zio.aws.databrew.model.ListRecipesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        recipeVersion.map(value => value)
      )
    def maxResults: Optional[MaxResults100]
    def nextToken: Optional[NextToken]
    def recipeVersion: Optional[RecipeVersion]
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecipeVersion: ZIO[Any, AwsError, RecipeVersion] =
      AwsError.unwrapOptionField("recipeVersion", recipeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipesRequest
  ) extends zio.aws.databrew.model.ListRecipesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val recipeVersion: Optional[RecipeVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeVersion())
      .map(value => zio.aws.databrew.model.primitives.RecipeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipesRequest
  ): zio.aws.databrew.model.ListRecipesRequest.ReadOnly = new Wrapper(impl)
}
