package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  JobRunId,
  Date,
  StartedBy,
  ExecutionTime,
  DatasetName,
  Attempt,
  JobName,
  LogGroupName,
  JobRunErrorMessage
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeJobRunResponse(
    attempt: Optional[Attempt] = Optional.Absent,
    completedOn: Optional[Date] = Optional.Absent,
    datasetName: Optional[DatasetName] = Optional.Absent,
    errorMessage: Optional[JobRunErrorMessage] = Optional.Absent,
    executionTime: Optional[ExecutionTime] = Optional.Absent,
    jobName: JobName,
    profileConfiguration: Optional[
      zio.aws.databrew.model.ProfileConfiguration
    ] = Optional.Absent,
    validationConfigurations: Optional[
      Iterable[zio.aws.databrew.model.ValidationConfiguration]
    ] = Optional.Absent,
    runId: Optional[JobRunId] = Optional.Absent,
    state: Optional[zio.aws.databrew.model.JobRunState] = Optional.Absent,
    logSubscription: Optional[zio.aws.databrew.model.LogSubscription] =
      Optional.Absent,
    logGroupName: Optional[LogGroupName] = Optional.Absent,
    outputs: Optional[Iterable[zio.aws.databrew.model.Output]] =
      Optional.Absent,
    dataCatalogOutputs: Optional[
      Iterable[zio.aws.databrew.model.DataCatalogOutput]
    ] = Optional.Absent,
    databaseOutputs: Optional[Iterable[zio.aws.databrew.model.DatabaseOutput]] =
      Optional.Absent,
    recipeReference: Optional[zio.aws.databrew.model.RecipeReference] =
      Optional.Absent,
    startedBy: Optional[StartedBy] = Optional.Absent,
    startedOn: Optional[Date] = Optional.Absent,
    jobSample: Optional[zio.aws.databrew.model.JobSample] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeJobRunResponse = {
    import DescribeJobRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeJobRunResponse
      .builder()
      .optionallyWith(attempt.map(value => Attempt.unwrap(value): Integer))(
        _.attempt
      )
      .optionallyWith(completedOn.map(value => Date.unwrap(value): Instant))(
        _.completedOn
      )
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        errorMessage.map(value =>
          JobRunErrorMessage.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        executionTime.map(value => ExecutionTime.unwrap(value): Integer)
      )(_.executionTime)
      .jobName(JobName.unwrap(jobName): java.lang.String)
      .optionallyWith(profileConfiguration.map(value => value.buildAwsValue()))(
        _.profileConfiguration
      )
      .optionallyWith(
        validationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationConfigurations)
      .optionallyWith(
        runId.map(value => JobRunId.unwrap(value): java.lang.String)
      )(_.runId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(logSubscription.map(value => value.unwrap))(
        _.logSubscription
      )
      .optionallyWith(
        logGroupName.map(value => LogGroupName.unwrap(value): java.lang.String)
      )(_.logGroupName)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCatalogOutputs)
      .optionallyWith(
        databaseOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databaseOutputs)
      .optionallyWith(recipeReference.map(value => value.buildAwsValue()))(
        _.recipeReference
      )
      .optionallyWith(
        startedBy.map(value => StartedBy.unwrap(value): java.lang.String)
      )(_.startedBy)
      .optionallyWith(startedOn.map(value => Date.unwrap(value): Instant))(
        _.startedOn
      )
      .optionallyWith(jobSample.map(value => value.buildAwsValue()))(
        _.jobSample
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly =
    zio.aws.databrew.model.DescribeJobRunResponse.wrap(buildAwsValue())
}
object DescribeJobRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeJobRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeJobRunResponse =
      zio.aws.databrew.model.DescribeJobRunResponse(
        attempt.map(value => value),
        completedOn.map(value => value),
        datasetName.map(value => value),
        errorMessage.map(value => value),
        executionTime.map(value => value),
        jobName,
        profileConfiguration.map(value => value.asEditable),
        validationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        runId.map(value => value),
        state.map(value => value),
        logSubscription.map(value => value),
        logGroupName.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        databaseOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recipeReference.map(value => value.asEditable),
        startedBy.map(value => value),
        startedOn.map(value => value),
        jobSample.map(value => value.asEditable)
      )
    def attempt: Optional[Attempt]
    def completedOn: Optional[Date]
    def datasetName: Optional[DatasetName]
    def errorMessage: Optional[JobRunErrorMessage]
    def executionTime: Optional[ExecutionTime]
    def jobName: JobName
    def profileConfiguration
        : Optional[zio.aws.databrew.model.ProfileConfiguration.ReadOnly]
    def validationConfigurations: Optional[
      List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]
    ]
    def runId: Optional[JobRunId]
    def state: Optional[zio.aws.databrew.model.JobRunState]
    def logSubscription: Optional[zio.aws.databrew.model.LogSubscription]
    def logGroupName: Optional[LogGroupName]
    def outputs: Optional[List[zio.aws.databrew.model.Output.ReadOnly]]
    def dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]]
    def databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]]
    def recipeReference
        : Optional[zio.aws.databrew.model.RecipeReference.ReadOnly]
    def startedBy: Optional[StartedBy]
    def startedOn: Optional[Date]
    def jobSample: Optional[zio.aws.databrew.model.JobSample.ReadOnly]
    def getAttempt: ZIO[Any, AwsError, Attempt] =
      AwsError.unwrapOptionField("attempt", attempt)
    def getCompletedOn: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("completedOn", completedOn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getErrorMessage: ZIO[Any, AwsError, JobRunErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getExecutionTime: ZIO[Any, AwsError, ExecutionTime] =
      AwsError.unwrapOptionField("executionTime", executionTime)
    def getJobName: ZIO[Any, Nothing, JobName] = ZIO.succeed(jobName)
    def getProfileConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.ProfileConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("profileConfiguration", profileConfiguration)
    def getValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "validationConfigurations",
      validationConfigurations
    )
    def getRunId: ZIO[Any, AwsError, JobRunId] =
      AwsError.unwrapOptionField("runId", runId)
    def getState: ZIO[Any, AwsError, zio.aws.databrew.model.JobRunState] =
      AwsError.unwrapOptionField("state", state)
    def getLogSubscription
        : ZIO[Any, AwsError, zio.aws.databrew.model.LogSubscription] =
      AwsError.unwrapOptionField("logSubscription", logSubscription)
    def getLogGroupName: ZIO[Any, AwsError, LogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getOutputs
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.Output.ReadOnly]] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getDataCatalogOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DataCatalogOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCatalogOutputs", dataCatalogOutputs)
    def getDatabaseOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DatabaseOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("databaseOutputs", databaseOutputs)
    def getRecipeReference
        : ZIO[Any, AwsError, zio.aws.databrew.model.RecipeReference.ReadOnly] =
      AwsError.unwrapOptionField("recipeReference", recipeReference)
    def getStartedBy: ZIO[Any, AwsError, StartedBy] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getStartedOn: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startedOn", startedOn)
    def getJobSample
        : ZIO[Any, AwsError, zio.aws.databrew.model.JobSample.ReadOnly] =
      AwsError.unwrapOptionField("jobSample", jobSample)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeJobRunResponse
  ) extends zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly {
    override val attempt: Optional[Attempt] = zio.aws.core.internal
      .optionalFromNullable(impl.attempt())
      .map(value => zio.aws.databrew.model.primitives.Attempt(value))
    override val completedOn: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.completedOn())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value => zio.aws.databrew.model.primitives.DatasetName(value))
    override val errorMessage: Optional[JobRunErrorMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value =>
          zio.aws.databrew.model.primitives.JobRunErrorMessage(value)
        )
    override val executionTime: Optional[ExecutionTime] = zio.aws.core.internal
      .optionalFromNullable(impl.executionTime())
      .map(value => zio.aws.databrew.model.primitives.ExecutionTime(value))
    override val jobName: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.jobName())
    override val profileConfiguration
        : Optional[zio.aws.databrew.model.ProfileConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileConfiguration())
        .map(value => zio.aws.databrew.model.ProfileConfiguration.wrap(value))
    override val validationConfigurations: Optional[
      List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ValidationConfiguration.wrap(item)
        }.toList
      )
    override val runId: Optional[JobRunId] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.databrew.model.primitives.JobRunId(value))
    override val state: Optional[zio.aws.databrew.model.JobRunState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.databrew.model.JobRunState.wrap(value))
    override val logSubscription
        : Optional[zio.aws.databrew.model.LogSubscription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logSubscription())
        .map(value => zio.aws.databrew.model.LogSubscription.wrap(value))
    override val logGroupName: Optional[LogGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupName())
      .map(value => zio.aws.databrew.model.primitives.LogGroupName(value))
    override val outputs
        : Optional[List[zio.aws.databrew.model.Output.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.Output.wrap(item)
          }.toList
        )
    override val dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCatalogOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DataCatalogOutput.wrap(item)
          }.toList
        )
    override val databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DatabaseOutput.wrap(item)
          }.toList
        )
    override val recipeReference
        : Optional[zio.aws.databrew.model.RecipeReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipeReference())
        .map(value => zio.aws.databrew.model.RecipeReference.wrap(value))
    override val startedBy: Optional[StartedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => zio.aws.databrew.model.primitives.StartedBy(value))
    override val startedOn: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startedOn())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val jobSample
        : Optional[zio.aws.databrew.model.JobSample.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobSample())
        .map(value => zio.aws.databrew.model.JobSample.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeJobRunResponse
  ): zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly = new Wrapper(impl)
}
