package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{HeaderRow, SheetIndex, SheetName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ExcelOptions(
    sheetNames: Optional[Iterable[SheetName]] = Optional.Absent,
    sheetIndexes: Optional[Iterable[SheetIndex]] = Optional.Absent,
    headerRow: Optional[HeaderRow] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ExcelOptions = {
    import ExcelOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ExcelOptions
      .builder()
      .optionallyWith(
        sheetNames.map(value =>
          value.map { item =>
            SheetName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sheetNames)
      .optionallyWith(
        sheetIndexes.map(value =>
          value.map { item =>
            SheetIndex.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.sheetIndexes)
      .optionallyWith(
        headerRow.map(value => HeaderRow.unwrap(value): java.lang.Boolean)
      )(_.headerRow)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ExcelOptions.ReadOnly =
    zio.aws.databrew.model.ExcelOptions.wrap(buildAwsValue())
}
object ExcelOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ExcelOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ExcelOptions =
      zio.aws.databrew.model.ExcelOptions(
        sheetNames.map(value => value),
        sheetIndexes.map(value => value),
        headerRow.map(value => value)
      )
    def sheetNames: Optional[List[SheetName]]
    def sheetIndexes: Optional[List[SheetIndex]]
    def headerRow: Optional[HeaderRow]
    def getSheetNames: ZIO[Any, AwsError, List[SheetName]] =
      AwsError.unwrapOptionField("sheetNames", sheetNames)
    def getSheetIndexes: ZIO[Any, AwsError, List[SheetIndex]] =
      AwsError.unwrapOptionField("sheetIndexes", sheetIndexes)
    def getHeaderRow: ZIO[Any, AwsError, HeaderRow] =
      AwsError.unwrapOptionField("headerRow", headerRow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ExcelOptions
  ) extends zio.aws.databrew.model.ExcelOptions.ReadOnly {
    override val sheetNames: Optional[List[SheetName]] = zio.aws.core.internal
      .optionalFromNullable(impl.sheetNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.SheetName(item)
        }.toList
      )
    override val sheetIndexes: Optional[List[SheetIndex]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sheetIndexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.primitives.SheetIndex(item)
          }.toList
        )
    override val headerRow: Optional[HeaderRow] = zio.aws.core.internal
      .optionalFromNullable(impl.headerRow())
      .map(value => zio.aws.databrew.model.primitives.HeaderRow(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ExcelOptions
  ): zio.aws.databrew.model.ExcelOptions.ReadOnly = new Wrapper(impl)
}
