package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{
  TagValue,
  RulesetDescription,
  Arn,
  RulesetName,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateRulesetRequest(
    name: RulesetName,
    description: Optional[RulesetDescription] = Optional.Absent,
    targetArn: Arn,
    rules: Iterable[zio.aws.databrew.model.Rule],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateRulesetRequest = {
    import CreateRulesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateRulesetRequest
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RulesetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .targetArn(Arn.unwrap(targetArn): java.lang.String)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateRulesetRequest.ReadOnly =
    zio.aws.databrew.model.CreateRulesetRequest.wrap(buildAwsValue())
}
object CreateRulesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateRulesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateRulesetRequest =
      zio.aws.databrew.model.CreateRulesetRequest(
        name,
        description.map(value => value),
        targetArn,
        rules.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def name: RulesetName
    def description: Optional[RulesetDescription]
    def targetArn: Arn
    def rules: List[zio.aws.databrew.model.Rule.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, RulesetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTargetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(targetArn)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.Rule.ReadOnly]] =
      ZIO.succeed(rules)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateRulesetRequest
  ) extends zio.aws.databrew.model.CreateRulesetRequest.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
    override val description: Optional[RulesetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.databrew.model.primitives.RulesetDescription(value)
        )
    override val targetArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.targetArn())
    override val rules: List[zio.aws.databrew.model.Rule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.databrew.model.Rule.wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateRulesetRequest
  ): zio.aws.databrew.model.CreateRulesetRequest.ReadOnly = new Wrapper(impl)
}
