package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  RecipeVersion,
  NextToken,
  MaxResults100
}
import scala.jdk.CollectionConverters.*
final case class ListRecipesRequest(
    maxResults: Option[MaxResults100] = None,
    nextToken: Option[NextToken] = None,
    recipeVersion: Option[RecipeVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRecipesRequest = {
    import ListRecipesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRecipesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        recipeVersion.map(value =>
          RecipeVersion.unwrap(value): java.lang.String
        )
      )(_.recipeVersion)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRecipesRequest.ReadOnly =
    zio.aws.databrew.model.ListRecipesRequest.wrap(buildAwsValue())
}
object ListRecipesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRecipesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRecipesRequest =
      zio.aws.databrew.model.ListRecipesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        recipeVersion.map(value => value)
      )
    def maxResults: Option[MaxResults100]
    def nextToken: Option[NextToken]
    def recipeVersion: Option[RecipeVersion]
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecipeVersion: ZIO[Any, AwsError, RecipeVersion] =
      AwsError.unwrapOptionField("recipeVersion", recipeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipesRequest
  ) extends zio.aws.databrew.model.ListRecipesRequest.ReadOnly {
    override val maxResults: Option[MaxResults100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val recipeVersion: Option[RecipeVersion] = scala
      .Option(impl.recipeVersion())
      .map(value => zio.aws.databrew.model.primitives.RecipeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipesRequest
  ): zio.aws.databrew.model.ListRecipesRequest.ReadOnly = new Wrapper(impl)
}
