package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databrew.model.primitives.{
  Date,
  LastModifiedBy,
  TagValue,
  RulesetDescription,
  Arn,
  RulesetName,
  CreatedBy,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class DescribeRulesetResponse(
    name: RulesetName,
    description: Option[RulesetDescription] = None,
    targetArn: Option[Arn] = None,
    rules: Option[Iterable[zio.aws.databrew.model.Rule]] = None,
    createDate: Option[Date] = None,
    createdBy: Option[CreatedBy] = None,
    lastModifiedBy: Option[LastModifiedBy] = None,
    lastModifiedDate: Option[Date] = None,
    resourceArn: Option[Arn] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse = {
    import DescribeRulesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RulesetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        targetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly =
    zio.aws.databrew.model.DescribeRulesetResponse.wrap(buildAwsValue())
}
object DescribeRulesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeRulesetResponse =
      zio.aws.databrew.model.DescribeRulesetResponse(
        name,
        description.map(value => value),
        targetArn.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDate.map(value => value),
        createdBy.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        resourceArn.map(value => value),
        tags.map(value => value)
      )
    def name: RulesetName
    def description: Option[RulesetDescription]
    def targetArn: Option[Arn]
    def rules: Option[List[zio.aws.databrew.model.Rule.ReadOnly]]
    def createDate: Option[Date]
    def createdBy: Option[CreatedBy]
    def lastModifiedBy: Option[LastModifiedBy]
    def lastModifiedDate: Option[Date]
    def resourceArn: Option[Arn]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, RulesetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTargetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
  ) extends zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
    override val description: Option[RulesetDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.databrew.model.primitives.RulesetDescription(value))
    override val targetArn: Option[Arn] = scala
      .Option(impl.targetArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val rules: Option[List[zio.aws.databrew.model.Rule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.Rule.wrap(item)
          }.toList
        )
    override val createDate: Option[Date] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val lastModifiedBy: Option[LastModifiedBy] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val resourceArn: Option[Arn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
  ): zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly = new Wrapper(impl)
}
