package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters.*
final case class DeleteJobRequest(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteJobRequest = {
    import DeleteJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteJobRequest
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteJobRequest.ReadOnly =
    zio.aws.databrew.model.DeleteJobRequest.wrap(buildAwsValue())
}
object DeleteJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteJobRequest =
      zio.aws.databrew.model.DeleteJobRequest(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteJobRequest
  ) extends zio.aws.databrew.model.DeleteJobRequest.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteJobRequest
  ): zio.aws.databrew.model.DeleteJobRequest.ReadOnly = new Wrapper(impl)
}
