package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ScheduleName
import scala.jdk.CollectionConverters.*
final case class DeleteScheduleResponse(name: ScheduleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteScheduleResponse = {
    import DeleteScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteScheduleResponse
      .builder()
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly =
    zio.aws.databrew.model.DeleteScheduleResponse.wrap(buildAwsValue())
}
object DeleteScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteScheduleResponse =
      zio.aws.databrew.model.DeleteScheduleResponse(name)
    def name: ScheduleName
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteScheduleResponse
  ) extends zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly {
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteScheduleResponse
  ): zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly = new Wrapper(impl)
}
