package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  TagValue,
  ScheduleName,
  CronExpression,
  JobName,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateScheduleRequest(
    jobNames: Option[Iterable[JobName]] = None,
    cronExpression: CronExpression,
    tags: Option[Map[TagKey, TagValue]] = None,
    name: ScheduleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateScheduleRequest = {
    import CreateScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateScheduleRequest
      .builder()
      .optionallyWith(
        jobNames.map(value =>
          value.map { item =>
            JobName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobNames)
      .cronExpression(CronExpression.unwrap(cronExpression): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateScheduleRequest.ReadOnly =
    zio.aws.databrew.model.CreateScheduleRequest.wrap(buildAwsValue())
}
object CreateScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateScheduleRequest =
      zio.aws.databrew.model.CreateScheduleRequest(
        jobNames.map(value => value),
        cronExpression,
        tags.map(value => value),
        name
      )
    def jobNames: Option[List[JobName]]
    def cronExpression: CronExpression
    def tags: Option[Map[TagKey, TagValue]]
    def name: ScheduleName
    def getJobNames: ZIO[Any, AwsError, List[JobName]] =
      AwsError.unwrapOptionField("jobNames", jobNames)
    def getCronExpression: ZIO[Any, Nothing, CronExpression] =
      ZIO.succeed(cronExpression)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateScheduleRequest
  ) extends zio.aws.databrew.model.CreateScheduleRequest.ReadOnly {
    override val jobNames: Option[List[JobName]] = scala
      .Option(impl.jobNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.JobName(item)
        }.toList
      )
    override val cronExpression: CronExpression =
      zio.aws.databrew.model.primitives.CronExpression(impl.cronExpression())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateScheduleRequest
  ): zio.aws.databrew.model.CreateScheduleRequest.ReadOnly = new Wrapper(impl)
}
