package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RulesetName
import scala.jdk.CollectionConverters.*
final case class UpdateRulesetResponse(name: RulesetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateRulesetResponse = {
    import UpdateRulesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateRulesetResponse
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly =
    zio.aws.databrew.model.UpdateRulesetResponse.wrap(buildAwsValue())
}
object UpdateRulesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateRulesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateRulesetResponse =
      zio.aws.databrew.model.UpdateRulesetResponse(name)
    def name: RulesetName
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRulesetResponse
  ) extends zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRulesetResponse
  ): zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly = new Wrapper(impl)
}
