package zio.aws.databrew.model
import scala.jdk.CollectionConverters.*
sealed trait InputFormat {
  def unwrap: software.amazon.awssdk.services.databrew.model.InputFormat
}
object InputFormat {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.InputFormat
  ): zio.aws.databrew.model.InputFormat = value match {
    case software.amazon.awssdk.services.databrew.model.InputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.InputFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.databrew.model.InputFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.databrew.model.InputFormat.PARQUET =>
      val r = PARQUET
      r
    case software.amazon.awssdk.services.databrew.model.InputFormat.EXCEL =>
      val r = EXCEL
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.InputFormat =
      software.amazon.awssdk.services.databrew.model.InputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.databrew.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.InputFormat =
      software.amazon.awssdk.services.databrew.model.InputFormat.CSV
  }
  case object JSON extends zio.aws.databrew.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.InputFormat =
      software.amazon.awssdk.services.databrew.model.InputFormat.JSON
  }
  case object PARQUET extends zio.aws.databrew.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.InputFormat =
      software.amazon.awssdk.services.databrew.model.InputFormat.PARQUET
  }
  case object EXCEL extends zio.aws.databrew.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.InputFormat =
      software.amazon.awssdk.services.databrew.model.InputFormat.EXCEL
  }
}
