package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databrew.model.primitives.{ProjectName, Date}
import scala.jdk.CollectionConverters.*
final case class UpdateProjectResponse(
    lastModifiedDate: Option[Date] = None,
    name: ProjectName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateProjectResponse = {
    import UpdateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateProjectResponse
      .builder()
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateProjectResponse.ReadOnly =
    zio.aws.databrew.model.UpdateProjectResponse.wrap(buildAwsValue())
}
object UpdateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateProjectResponse =
      zio.aws.databrew.model
        .UpdateProjectResponse(lastModifiedDate.map(value => value), name)
    def lastModifiedDate: Option[Date]
    def name: ProjectName
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProjectResponse
  ) extends zio.aws.databrew.model.UpdateProjectResponse.ReadOnly {
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateProjectResponse
  ): zio.aws.databrew.model.UpdateProjectResponse.ReadOnly = new Wrapper(impl)
}
