package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  ProjectName,
  NextToken,
  MaxResults100,
  DatasetName
}
import scala.jdk.CollectionConverters.*
final case class ListJobsRequest(
    datasetName: Option[DatasetName] = None,
    maxResults: Option[MaxResults100] = None,
    nextToken: Option[NextToken] = None,
    projectName: Option[ProjectName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListJobsRequest
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListJobsRequest.ReadOnly =
    zio.aws.databrew.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListJobsRequest =
      zio.aws.databrew.model.ListJobsRequest(
        datasetName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        projectName.map(value => value)
      )
    def datasetName: Option[DatasetName]
    def maxResults: Option[MaxResults100]
    def nextToken: Option[NextToken]
    def projectName: Option[ProjectName]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListJobsRequest
  ) extends zio.aws.databrew.model.ListJobsRequest.ReadOnly {
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value => zio.aws.databrew.model.primitives.DatasetName(value))
    override val maxResults: Option[MaxResults100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val projectName: Option[ProjectName] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.databrew.model.primitives.ProjectName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListJobsRequest
  ): zio.aws.databrew.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
