package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databrew.model.primitives.{
  RecipeDescription,
  RecipeVersion,
  ProjectName,
  Date,
  LastModifiedBy,
  TagValue,
  Arn,
  PublishedBy,
  CreatedBy,
  RecipeName,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class DescribeRecipeResponse(
    createdBy: Option[CreatedBy] = None,
    createDate: Option[Date] = None,
    lastModifiedBy: Option[LastModifiedBy] = None,
    lastModifiedDate: Option[Date] = None,
    projectName: Option[ProjectName] = None,
    publishedBy: Option[PublishedBy] = None,
    publishedDate: Option[Date] = None,
    description: Option[RecipeDescription] = None,
    name: RecipeName,
    steps: Option[Iterable[zio.aws.databrew.model.RecipeStep]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    resourceArn: Option[Arn] = None,
    recipeVersion: Option[RecipeVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeRecipeResponse = {
    import DescribeRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeRecipeResponse
      .builder()
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        publishedBy.map(value => PublishedBy.unwrap(value): java.lang.String)
      )(_.publishedBy)
      .optionallyWith(publishedDate.map(value => Date.unwrap(value): Instant))(
        _.publishedDate
      )
      .optionallyWith(
        description.map(value =>
          RecipeDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(RecipeName.unwrap(name): java.lang.String)
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        recipeVersion.map(value =>
          RecipeVersion.unwrap(value): java.lang.String
        )
      )(_.recipeVersion)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly =
    zio.aws.databrew.model.DescribeRecipeResponse.wrap(buildAwsValue())
}
object DescribeRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeRecipeResponse =
      zio.aws.databrew.model.DescribeRecipeResponse(
        createdBy.map(value => value),
        createDate.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        projectName.map(value => value),
        publishedBy.map(value => value),
        publishedDate.map(value => value),
        description.map(value => value),
        name,
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        resourceArn.map(value => value),
        recipeVersion.map(value => value)
      )
    def createdBy: Option[CreatedBy]
    def createDate: Option[Date]
    def lastModifiedBy: Option[LastModifiedBy]
    def lastModifiedDate: Option[Date]
    def projectName: Option[ProjectName]
    def publishedBy: Option[PublishedBy]
    def publishedDate: Option[Date]
    def description: Option[RecipeDescription]
    def name: RecipeName
    def steps: Option[List[zio.aws.databrew.model.RecipeStep.ReadOnly]]
    def tags: Option[Map[TagKey, TagValue]]
    def resourceArn: Option[Arn]
    def recipeVersion: Option[RecipeVersion]
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getPublishedBy: ZIO[Any, AwsError, PublishedBy] =
      AwsError.unwrapOptionField("publishedBy", publishedBy)
    def getPublishedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("publishedDate", publishedDate)
    def getDescription: ZIO[Any, AwsError, RecipeDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getSteps
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.RecipeStep.ReadOnly]] =
      AwsError.unwrapOptionField("steps", steps)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRecipeVersion: ZIO[Any, AwsError, RecipeVersion] =
      AwsError.unwrapOptionField("recipeVersion", recipeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRecipeResponse
  ) extends zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly {
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val createDate: Option[Date] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val lastModifiedBy: Option[LastModifiedBy] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val projectName: Option[ProjectName] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.databrew.model.primitives.ProjectName(value))
    override val publishedBy: Option[PublishedBy] = scala
      .Option(impl.publishedBy())
      .map(value => zio.aws.databrew.model.primitives.PublishedBy(value))
    override val publishedDate: Option[Date] = scala
      .Option(impl.publishedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val description: Option[RecipeDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.databrew.model.primitives.RecipeDescription(value))
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val steps
        : Option[List[zio.aws.databrew.model.RecipeStep.ReadOnly]] = scala
      .Option(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.RecipeStep.wrap(item)
        }.toList
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val resourceArn: Option[Arn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val recipeVersion: Option[RecipeVersion] = scala
      .Option(impl.recipeVersion())
      .map(value => zio.aws.databrew.model.primitives.RecipeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRecipeResponse
  ): zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly = new Wrapper(impl)
}
