package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ProfileConfiguration(
    datasetStatisticsConfiguration: Option[
      zio.aws.databrew.model.StatisticsConfiguration
    ] = None,
    profileColumns: Option[Iterable[zio.aws.databrew.model.ColumnSelector]] =
      None,
    columnStatisticsConfigurations: Option[
      Iterable[zio.aws.databrew.model.ColumnStatisticsConfiguration]
    ] = None,
    entityDetectorConfiguration: Option[
      zio.aws.databrew.model.EntityDetectorConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ProfileConfiguration = {
    import ProfileConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ProfileConfiguration
      .builder()
      .optionallyWith(
        datasetStatisticsConfiguration.map(value => value.buildAwsValue())
      )(_.datasetStatisticsConfiguration)
      .optionallyWith(
        profileColumns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profileColumns)
      .optionallyWith(
        columnStatisticsConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnStatisticsConfigurations)
      .optionallyWith(
        entityDetectorConfiguration.map(value => value.buildAwsValue())
      )(_.entityDetectorConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ProfileConfiguration.ReadOnly =
    zio.aws.databrew.model.ProfileConfiguration.wrap(buildAwsValue())
}
object ProfileConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ProfileConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ProfileConfiguration =
      zio.aws.databrew.model.ProfileConfiguration(
        datasetStatisticsConfiguration.map(value => value.asEditable),
        profileColumns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        columnStatisticsConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entityDetectorConfiguration.map(value => value.asEditable)
      )
    def datasetStatisticsConfiguration
        : Option[zio.aws.databrew.model.StatisticsConfiguration.ReadOnly]
    def profileColumns
        : Option[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]]
    def columnStatisticsConfigurations: Option[
      List[zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly]
    ]
    def entityDetectorConfiguration
        : Option[zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly]
    def getDatasetStatisticsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.StatisticsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "datasetStatisticsConfiguration",
      datasetStatisticsConfiguration
    )
    def getProfileColumns: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ColumnSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("profileColumns", profileColumns)
    def getColumnStatisticsConfigurations: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "columnStatisticsConfigurations",
      columnStatisticsConfigurations
    )
    def getEntityDetectorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "entityDetectorConfiguration",
      entityDetectorConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ProfileConfiguration
  ) extends zio.aws.databrew.model.ProfileConfiguration.ReadOnly {
    override val datasetStatisticsConfiguration
        : Option[zio.aws.databrew.model.StatisticsConfiguration.ReadOnly] =
      scala
        .Option(impl.datasetStatisticsConfiguration())
        .map(value =>
          zio.aws.databrew.model.StatisticsConfiguration.wrap(value)
        )
    override val profileColumns
        : Option[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]] = scala
      .Option(impl.profileColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ColumnSelector.wrap(item)
        }.toList
      )
    override val columnStatisticsConfigurations: Option[
      List[zio.aws.databrew.model.ColumnStatisticsConfiguration.ReadOnly]
    ] = scala
      .Option(impl.columnStatisticsConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ColumnStatisticsConfiguration.wrap(item)
        }.toList
      )
    override val entityDetectorConfiguration
        : Option[zio.aws.databrew.model.EntityDetectorConfiguration.ReadOnly] =
      scala
        .Option(impl.entityDetectorConfiguration())
        .map(value =>
          zio.aws.databrew.model.EntityDetectorConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ProfileConfiguration
  ): zio.aws.databrew.model.ProfileConfiguration.ReadOnly = new Wrapper(impl)
}
