package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ScheduleName
import scala.jdk.CollectionConverters.*
final case class UpdateScheduleResponse(name: ScheduleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateScheduleResponse = {
    import UpdateScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateScheduleResponse
      .builder()
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly =
    zio.aws.databrew.model.UpdateScheduleResponse.wrap(buildAwsValue())
}
object UpdateScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateScheduleResponse =
      zio.aws.databrew.model.UpdateScheduleResponse(name)
    def name: ScheduleName
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateScheduleResponse
  ) extends zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly {
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateScheduleResponse
  ): zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly = new Wrapper(impl)
}
