package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.PathParameterName
import scala.jdk.CollectionConverters.*
final case class PathOptions(
    lastModifiedDateCondition: Option[zio.aws.databrew.model.FilterExpression] =
      None,
    filesLimit: Option[zio.aws.databrew.model.FilesLimit] = None,
    parameters: Option[
      Map[PathParameterName, zio.aws.databrew.model.DatasetParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.PathOptions = {
    import PathOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.PathOptions
      .builder()
      .optionallyWith(
        lastModifiedDateCondition.map(value => value.buildAwsValue())
      )(_.lastModifiedDateCondition)
      .optionallyWith(filesLimit.map(value => value.buildAwsValue()))(
        _.filesLimit
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (PathParameterName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.PathOptions.ReadOnly =
    zio.aws.databrew.model.PathOptions.wrap(buildAwsValue())
}
object PathOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.PathOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.PathOptions =
      zio.aws.databrew.model.PathOptions(
        lastModifiedDateCondition.map(value => value.asEditable),
        filesLimit.map(value => value.asEditable),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def lastModifiedDateCondition
        : Option[zio.aws.databrew.model.FilterExpression.ReadOnly]
    def filesLimit: Option[zio.aws.databrew.model.FilesLimit.ReadOnly]
    def parameters: Option[
      Map[PathParameterName, zio.aws.databrew.model.DatasetParameter.ReadOnly]
    ]
    def getLastModifiedDateCondition
        : ZIO[Any, AwsError, zio.aws.databrew.model.FilterExpression.ReadOnly] =
      AwsError.unwrapOptionField(
        "lastModifiedDateCondition",
        lastModifiedDateCondition
      )
    def getFilesLimit
        : ZIO[Any, AwsError, zio.aws.databrew.model.FilesLimit.ReadOnly] =
      AwsError.unwrapOptionField("filesLimit", filesLimit)
    def getParameters: ZIO[Any, AwsError, Map[
      PathParameterName,
      zio.aws.databrew.model.DatasetParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.PathOptions
  ) extends zio.aws.databrew.model.PathOptions.ReadOnly {
    override val lastModifiedDateCondition
        : Option[zio.aws.databrew.model.FilterExpression.ReadOnly] = scala
      .Option(impl.lastModifiedDateCondition())
      .map(value => zio.aws.databrew.model.FilterExpression.wrap(value))
    override val filesLimit
        : Option[zio.aws.databrew.model.FilesLimit.ReadOnly] = scala
      .Option(impl.filesLimit())
      .map(value => zio.aws.databrew.model.FilesLimit.wrap(value))
    override val parameters: Option[
      Map[PathParameterName, zio.aws.databrew.model.DatasetParameter.ReadOnly]
    ] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives.PathParameterName(
              key
            ) -> zio.aws.databrew.model.DatasetParameter.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.PathOptions
  ): zio.aws.databrew.model.PathOptions.ReadOnly = new Wrapper(impl)
}
