package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{MaxResults100, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListProjectsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListProjectsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListProjectsRequest.ReadOnly =
    zio.aws.databrew.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListProjectsRequest =
      zio.aws.databrew.model.ListProjectsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults100]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListProjectsRequest
  ) extends zio.aws.databrew.model.ListProjectsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListProjectsRequest
  ): zio.aws.databrew.model.ListProjectsRequest.ReadOnly = new Wrapper(impl)
}
