package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{AssumeControl, ProjectName}
import scala.jdk.CollectionConverters.*
final case class StartProjectSessionRequest(
    name: ProjectName,
    assumeControl: Option[AssumeControl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StartProjectSessionRequest = {
    import StartProjectSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StartProjectSessionRequest
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(
        assumeControl.map(value =>
          AssumeControl.unwrap(value): java.lang.Boolean
        )
      )(_.assumeControl)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StartProjectSessionRequest.ReadOnly =
    zio.aws.databrew.model.StartProjectSessionRequest.wrap(buildAwsValue())
}
object StartProjectSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StartProjectSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StartProjectSessionRequest =
      zio.aws.databrew.model
        .StartProjectSessionRequest(name, assumeControl.map(value => value))
    def name: ProjectName
    def assumeControl: Option[AssumeControl]
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getAssumeControl: ZIO[Any, AwsError, AssumeControl] =
      AwsError.unwrapOptionField("assumeControl", assumeControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StartProjectSessionRequest
  ) extends zio.aws.databrew.model.StartProjectSessionRequest.ReadOnly {
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
    override val assumeControl: Option[AssumeControl] = scala
      .Option(impl.assumeControl())
      .map(value => zio.aws.databrew.model.primitives.AssumeControl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StartProjectSessionRequest
  ): zio.aws.databrew.model.StartProjectSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
