package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  ClientSessionId,
  StepIndex,
  ProjectName,
  Preview
}
import scala.jdk.CollectionConverters.*
final case class SendProjectSessionActionRequest(
    preview: Option[Preview] = None,
    name: ProjectName,
    recipeStep: Option[zio.aws.databrew.model.RecipeStep] = None,
    stepIndex: Option[StepIndex] = None,
    clientSessionId: Option[ClientSessionId] = None,
    viewFrame: Option[zio.aws.databrew.model.ViewFrame] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest = {
    import SendProjectSessionActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
      .builder()
      .optionallyWith(
        preview.map(value => Preview.unwrap(value): java.lang.Boolean)
      )(_.preview)
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(recipeStep.map(value => value.buildAwsValue()))(
        _.recipeStep
      )
      .optionallyWith(stepIndex.map(value => StepIndex.unwrap(value): Integer))(
        _.stepIndex
      )
      .optionallyWith(
        clientSessionId.map(value =>
          ClientSessionId.unwrap(value): java.lang.String
        )
      )(_.clientSessionId)
      .optionallyWith(viewFrame.map(value => value.buildAwsValue()))(
        _.viewFrame
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databrew.model.SendProjectSessionActionRequest.ReadOnly =
    zio.aws.databrew.model.SendProjectSessionActionRequest.wrap(buildAwsValue())
}
object SendProjectSessionActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.SendProjectSessionActionRequest =
      zio.aws.databrew.model.SendProjectSessionActionRequest(
        preview.map(value => value),
        name,
        recipeStep.map(value => value.asEditable),
        stepIndex.map(value => value),
        clientSessionId.map(value => value),
        viewFrame.map(value => value.asEditable)
      )
    def preview: Option[Preview]
    def name: ProjectName
    def recipeStep: Option[zio.aws.databrew.model.RecipeStep.ReadOnly]
    def stepIndex: Option[StepIndex]
    def clientSessionId: Option[ClientSessionId]
    def viewFrame: Option[zio.aws.databrew.model.ViewFrame.ReadOnly]
    def getPreview: ZIO[Any, AwsError, Preview] =
      AwsError.unwrapOptionField("preview", preview)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getRecipeStep
        : ZIO[Any, AwsError, zio.aws.databrew.model.RecipeStep.ReadOnly] =
      AwsError.unwrapOptionField("recipeStep", recipeStep)
    def getStepIndex: ZIO[Any, AwsError, StepIndex] =
      AwsError.unwrapOptionField("stepIndex", stepIndex)
    def getClientSessionId: ZIO[Any, AwsError, ClientSessionId] =
      AwsError.unwrapOptionField("clientSessionId", clientSessionId)
    def getViewFrame
        : ZIO[Any, AwsError, zio.aws.databrew.model.ViewFrame.ReadOnly] =
      AwsError.unwrapOptionField("viewFrame", viewFrame)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
  ) extends zio.aws.databrew.model.SendProjectSessionActionRequest.ReadOnly {
    override val preview: Option[Preview] = scala
      .Option(impl.preview())
      .map(value => zio.aws.databrew.model.primitives.Preview(value))
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
    override val recipeStep
        : Option[zio.aws.databrew.model.RecipeStep.ReadOnly] = scala
      .Option(impl.recipeStep())
      .map(value => zio.aws.databrew.model.RecipeStep.wrap(value))
    override val stepIndex: Option[StepIndex] = scala
      .Option(impl.stepIndex())
      .map(value => zio.aws.databrew.model.primitives.StepIndex(value))
    override val clientSessionId: Option[ClientSessionId] = scala
      .Option(impl.clientSessionId())
      .map(value => zio.aws.databrew.model.primitives.ClientSessionId(value))
    override val viewFrame: Option[zio.aws.databrew.model.ViewFrame.ReadOnly] =
      scala
        .Option(impl.viewFrame())
        .map(value => zio.aws.databrew.model.ViewFrame.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
  ): zio.aws.databrew.model.SendProjectSessionActionRequest.ReadOnly =
    new Wrapper(impl)
}
