package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.DatasetName
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetRequest(
    name: DatasetName,
    format: Option[zio.aws.databrew.model.InputFormat] = None,
    formatOptions: Option[zio.aws.databrew.model.FormatOptions] = None,
    input: zio.aws.databrew.model.Input,
    pathOptions: Option[zio.aws.databrew.model.PathOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest = {
    import UpdateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .input(input.buildAwsValue())
      .optionallyWith(pathOptions.map(value => value.buildAwsValue()))(
        _.pathOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateDatasetRequest.ReadOnly =
    zio.aws.databrew.model.UpdateDatasetRequest.wrap(buildAwsValue())
}
object UpdateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateDatasetRequest =
      zio.aws.databrew.model.UpdateDatasetRequest(
        name,
        format.map(value => value),
        formatOptions.map(value => value.asEditable),
        input.asEditable,
        pathOptions.map(value => value.asEditable)
      )
    def name: DatasetName
    def format: Option[zio.aws.databrew.model.InputFormat]
    def formatOptions: Option[zio.aws.databrew.model.FormatOptions.ReadOnly]
    def input: zio.aws.databrew.model.Input.ReadOnly
    def pathOptions: Option[zio.aws.databrew.model.PathOptions.ReadOnly]
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
    def getFormat: ZIO[Any, AwsError, zio.aws.databrew.model.InputFormat] =
      AwsError.unwrapOptionField("format", format)
    def getFormatOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.FormatOptions.ReadOnly] =
      AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getInput: ZIO[Any, Nothing, zio.aws.databrew.model.Input.ReadOnly] =
      ZIO.succeed(input)
    def getPathOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.PathOptions.ReadOnly] =
      AwsError.unwrapOptionField("pathOptions", pathOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
  ) extends zio.aws.databrew.model.UpdateDatasetRequest.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
    override val format: Option[zio.aws.databrew.model.InputFormat] = scala
      .Option(impl.format())
      .map(value => zio.aws.databrew.model.InputFormat.wrap(value))
    override val formatOptions
        : Option[zio.aws.databrew.model.FormatOptions.ReadOnly] = scala
      .Option(impl.formatOptions())
      .map(value => zio.aws.databrew.model.FormatOptions.wrap(value))
    override val input: zio.aws.databrew.model.Input.ReadOnly =
      zio.aws.databrew.model.Input.wrap(impl.input())
    override val pathOptions
        : Option[zio.aws.databrew.model.PathOptions.ReadOnly] = scala
      .Option(impl.pathOptions())
      .map(value => zio.aws.databrew.model.PathOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateDatasetRequest
  ): zio.aws.databrew.model.UpdateDatasetRequest.ReadOnly = new Wrapper(impl)
}
