package zio.aws.databrew.model
import scala.jdk.CollectionConverters.*
sealed trait SampleMode {
  def unwrap: software.amazon.awssdk.services.databrew.model.SampleMode
}
object SampleMode {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.SampleMode
  ): zio.aws.databrew.model.SampleMode = value match {
    case software.amazon.awssdk.services.databrew.model.SampleMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.SampleMode.FULL_DATASET =>
      val r = FULL_DATASET
      r
    case software.amazon.awssdk.services.databrew.model.SampleMode.CUSTOM_ROWS =>
      val r = CUSTOM_ROWS
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.SampleMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SampleMode =
      software.amazon.awssdk.services.databrew.model.SampleMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_DATASET extends zio.aws.databrew.model.SampleMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SampleMode =
      software.amazon.awssdk.services.databrew.model.SampleMode.FULL_DATASET
  }
  case object CUSTOM_ROWS extends zio.aws.databrew.model.SampleMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SampleMode =
      software.amazon.awssdk.services.databrew.model.SampleMode.CUSTOM_ROWS
  }
}
