package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  Disabled,
  ValueReference,
  RuleName,
  Expression,
  ConditionValue
}
import scala.jdk.CollectionConverters.*
final case class Rule(
    name: RuleName,
    disabled: Option[Disabled] = None,
    checkExpression: Expression,
    substitutionMap: Option[Map[ValueReference, ConditionValue]] = None,
    threshold: Option[zio.aws.databrew.model.Threshold] = None,
    columnSelectors: Option[Iterable[zio.aws.databrew.model.ColumnSelector]] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Rule
      .builder()
      .name(RuleName.unwrap(name): java.lang.String)
      .optionallyWith(
        disabled.map(value => Disabled.unwrap(value): java.lang.Boolean)
      )(_.disabled)
      .checkExpression(Expression.unwrap(checkExpression): java.lang.String)
      .optionallyWith(
        substitutionMap.map(value =>
          value
            .map({ case (key, value) =>
              (ValueReference.unwrap(key): java.lang.String) -> (ConditionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.substitutionMap)
      .optionallyWith(threshold.map(value => value.buildAwsValue()))(
        _.threshold
      )
      .optionallyWith(
        columnSelectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnSelectors)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Rule.ReadOnly =
    zio.aws.databrew.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Rule = zio.aws.databrew.model.Rule(
      name,
      disabled.map(value => value),
      checkExpression,
      substitutionMap.map(value => value),
      threshold.map(value => value.asEditable),
      columnSelectors.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def name: RuleName
    def disabled: Option[Disabled]
    def checkExpression: Expression
    def substitutionMap: Option[Map[ValueReference, ConditionValue]]
    def threshold: Option[zio.aws.databrew.model.Threshold.ReadOnly]
    def columnSelectors
        : Option[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]]
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getDisabled: ZIO[Any, AwsError, Disabled] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getCheckExpression: ZIO[Any, Nothing, Expression] =
      ZIO.succeed(checkExpression)
    def getSubstitutionMap
        : ZIO[Any, AwsError, Map[ValueReference, ConditionValue]] =
      AwsError.unwrapOptionField("substitutionMap", substitutionMap)
    def getThreshold
        : ZIO[Any, AwsError, zio.aws.databrew.model.Threshold.ReadOnly] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getColumnSelectors: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ColumnSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("columnSelectors", columnSelectors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Rule
  ) extends zio.aws.databrew.model.Rule.ReadOnly {
    override val name: RuleName =
      zio.aws.databrew.model.primitives.RuleName(impl.name())
    override val disabled: Option[Disabled] = scala
      .Option(impl.disabled())
      .map(value => zio.aws.databrew.model.primitives.Disabled(value))
    override val checkExpression: Expression =
      zio.aws.databrew.model.primitives.Expression(impl.checkExpression())
    override val substitutionMap: Option[Map[ValueReference, ConditionValue]] =
      scala
        .Option(impl.substitutionMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.databrew.model.primitives.ValueReference(
                key
              ) -> zio.aws.databrew.model.primitives.ConditionValue(value)
            })
            .toMap
        )
    override val threshold: Option[zio.aws.databrew.model.Threshold.ReadOnly] =
      scala
        .Option(impl.threshold())
        .map(value => zio.aws.databrew.model.Threshold.wrap(value))
    override val columnSelectors
        : Option[List[zio.aws.databrew.model.ColumnSelector.ReadOnly]] = scala
      .Option(impl.columnSelectors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ColumnSelector.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Rule
  ): zio.aws.databrew.model.Rule.ReadOnly = new Wrapper(impl)
}
