package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class Metadata(sourceArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.Metadata = {
    import Metadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Metadata
      .builder()
      .optionallyWith(
        sourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Metadata.ReadOnly =
    zio.aws.databrew.model.Metadata.wrap(buildAwsValue())
}
object Metadata {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Metadata] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Metadata =
      zio.aws.databrew.model.Metadata(sourceArn.map(value => value))
    def sourceArn: Option[Arn]
    def getSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Metadata
  ) extends zio.aws.databrew.model.Metadata.ReadOnly {
    override val sourceArn: Option[Arn] = scala
      .Option(impl.sourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Metadata
  ): zio.aws.databrew.model.Metadata.ReadOnly = new Wrapper(impl)
}
