package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters.*
final case class DescribeJobRequest(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeJobRequest = {
    import DescribeJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeJobRequest
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeJobRequest.ReadOnly =
    zio.aws.databrew.model.DescribeJobRequest.wrap(buildAwsValue())
}
object DescribeJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeJobRequest =
      zio.aws.databrew.model.DescribeJobRequest(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeJobRequest
  ) extends zio.aws.databrew.model.DescribeJobRequest.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeJobRequest
  ): zio.aws.databrew.model.DescribeJobRequest.ReadOnly = new Wrapper(impl)
}
